/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteMethodRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteMethodRequestMarshaller
implements Marshaller<Request<DeleteMethodRequest>, DeleteMethodRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteMethodRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteMethodRequest> marshall(DeleteMethodRequest deleteMethodRequest) {
        if (deleteMethodRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMethodRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", deleteMethodRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteMethodRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", deleteMethodRequest.getResourceId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteMethodRequest.getResourceId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", deleteMethodRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteMethodRequest.getHttpMethod()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

