/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetStageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetStageRequestMarshaller
implements Marshaller<Request<GetStageRequest>, GetStageRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetStageRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetStageRequest> marshall(GetStageRequest getStageRequest) {
        if (getStageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getStageRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getStageRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getStageRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{stage_name}", getStageRequest.getStageName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getStageRequest.getStageName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

