/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeLaunchTemplateVersionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLaunchTemplateVersionsRequestMarshaller
implements Marshaller<Request<DescribeLaunchTemplateVersionsRequest>, DescribeLaunchTemplateVersionsRequest> {
    public Request<DescribeLaunchTemplateVersionsRequest> marshall(DescribeLaunchTemplateVersionsRequest describeLaunchTemplateVersionsRequest) {
        SdkInternalList describeLaunchTemplateVersionsRequestFiltersList;
        SdkInternalList describeLaunchTemplateVersionsRequestVersionsList;
        if (describeLaunchTemplateVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLaunchTemplateVersionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeLaunchTemplateVersions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLaunchTemplateVersionsRequest.getLaunchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringUtils.fromString((String)describeLaunchTemplateVersionsRequest.getLaunchTemplateId()));
        }
        if (describeLaunchTemplateVersionsRequest.getLaunchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringUtils.fromString((String)describeLaunchTemplateVersionsRequest.getLaunchTemplateName()));
        }
        if (!(describeLaunchTemplateVersionsRequestVersionsList = (SdkInternalList)describeLaunchTemplateVersionsRequest.getVersions()).isEmpty() || !describeLaunchTemplateVersionsRequestVersionsList.isAutoConstruct()) {
            int versionsListIndex = 1;
            for (String describeLaunchTemplateVersionsRequestVersionsListValue : describeLaunchTemplateVersionsRequestVersionsList) {
                if (describeLaunchTemplateVersionsRequestVersionsListValue != null) {
                    request.addParameter("LaunchTemplateVersion." + versionsListIndex, StringUtils.fromString((String)describeLaunchTemplateVersionsRequestVersionsListValue));
                }
                ++versionsListIndex;
            }
        }
        if (describeLaunchTemplateVersionsRequest.getMinVersion() != null) {
            request.addParameter("MinVersion", StringUtils.fromString((String)describeLaunchTemplateVersionsRequest.getMinVersion()));
        }
        if (describeLaunchTemplateVersionsRequest.getMaxVersion() != null) {
            request.addParameter("MaxVersion", StringUtils.fromString((String)describeLaunchTemplateVersionsRequest.getMaxVersion()));
        }
        if (describeLaunchTemplateVersionsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeLaunchTemplateVersionsRequest.getNextToken()));
        }
        if (describeLaunchTemplateVersionsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeLaunchTemplateVersionsRequest.getMaxResults()));
        }
        if (!(describeLaunchTemplateVersionsRequestFiltersList = (SdkInternalList)describeLaunchTemplateVersionsRequest.getFilters()).isEmpty() || !describeLaunchTemplateVersionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeLaunchTemplateVersionsRequestFiltersListValue : describeLaunchTemplateVersionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeLaunchTemplateVersionsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeLaunchTemplateVersionsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeLaunchTemplateVersionsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

