// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.security.keyvault.secrets.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/**
 * A Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when it will be
 * purged.
 */
@Fluent
public final class DeletedSecretBundle extends SecretBundle {
    /*
     * The url of the recovery object, used to identify and recover the deleted secret.
     */
    private String recoveryId;

    /*
     * The time when the secret is scheduled to be purged, in UTC
     */
    private Long scheduledPurgeDate;

    /*
     * The time when the secret was deleted, in UTC
     */
    private Long deletedDate;

    /** Creates an instance of DeletedSecretBundle class. */
    public DeletedSecretBundle() {
    }

    /**
     * Get the recoveryId property: The url of the recovery object, used to identify and recover the deleted secret.
     *
     * @return the recoveryId value.
     */
    public String getRecoveryId() {
        return this.recoveryId;
    }

    /**
     * Set the recoveryId property: The url of the recovery object, used to identify and recover the deleted secret.
     *
     * @param recoveryId the recoveryId value to set.
     * @return the DeletedSecretBundle object itself.
     */
    public DeletedSecretBundle setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    /**
     * Get the scheduledPurgeDate property: The time when the secret is scheduled to be purged, in UTC.
     *
     * @return the scheduledPurgeDate value.
     */
    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    /**
     * Get the deletedDate property: The time when the secret was deleted, in UTC.
     *
     * @return the deletedDate value.
     */
    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretBundle setValue(String value) {
        super.setValue(value);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretBundle setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretBundle setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretBundle setAttributes(SecretAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public DeletedSecretBundle setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", getValue());
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeStringField("contentType", getContentType());
        jsonWriter.writeJsonField("attributes", getAttributes());
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeletedSecretBundle from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeletedSecretBundle if the JsonReader was pointing to an instance of it, or null if it was
     *     pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeletedSecretBundle.
     */
    public static DeletedSecretBundle fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedSecretBundle deserializedDeletedSecretBundle = new DeletedSecretBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setValue(reader.getString());
                } else if ("id".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setId(reader.getString());
                } else if ("contentType".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setContentType(reader.getString());
                } else if ("attributes".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setAttributes(SecretAttributes.fromJson(reader));
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedSecretBundle.setTags(tags);
                } else if ("kid".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setKid(reader.getString());
                } else if ("managed".equals(fieldName)) {
                    deserializedDeletedSecretBundle.setManaged(reader.getNullable(JsonReader::getBoolean));
                } else if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedSecretBundle.recoveryId = reader.getString();
                } else if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedSecretBundle.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                } else if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedSecretBundle.deletedDate = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeletedSecretBundle;
        });
    }
}
