/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.jms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.jms.support.QosSettings;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spring.jms.servicebus")
public class AzureServiceBusJMSProperties {
    private String connectionString;
    private String topicClientId;
    private int idleTimeout = 1800000;
    private String pricingTier;
    private final Listener listener = new Listener();

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getTopicClientId() {
        return this.topicClientId;
    }

    public void setTopicClientId(String topicClientId) {
        this.topicClientId = topicClientId;
    }

    public String getPricingTier() {
        return this.pricingTier;
    }

    public void setPricingTier(String pricingTier) {
        this.pricingTier = pricingTier;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Listener getListener() {
        return this.listener;
    }

    @PostConstruct
    @SuppressFBWarnings
    public void validate() {
        if (!StringUtils.hasText((String)this.connectionString)) {
            throw new IllegalArgumentException("'spring.jms.servicebus.connection-string' should be provided");
        }
        if (!this.pricingTier.matches("(?i)premium|standard|basic")) {
            throw new IllegalArgumentException("'spring.jms.servicebus.pricing-tier' is not valid");
        }
    }

    public static class Listener {
        private Boolean replyPubSubDomain;
        private QosSettings replyQosSettings;
        private Boolean subscriptionDurable = Boolean.TRUE;
        private Boolean subscriptionShared;
        private Integer phase;

        public Boolean isReplyPubSubDomain() {
            return this.replyPubSubDomain;
        }

        public void setReplyPubSubDomain(Boolean replyPubSubDomain) {
            this.replyPubSubDomain = replyPubSubDomain;
        }

        public QosSettings getReplyQosSettings() {
            return this.replyQosSettings;
        }

        public void setReplyQosSettings(QosSettings replyQosSettings) {
            this.replyQosSettings = replyQosSettings;
        }

        public Boolean isSubscriptionDurable() {
            return this.subscriptionDurable;
        }

        public void setSubscriptionDurable(Boolean subscriptionDurable) {
            this.subscriptionDurable = subscriptionDurable;
        }

        public Boolean isSubscriptionShared() {
            return this.subscriptionShared;
        }

        public void setSubscriptionShared(Boolean subscriptionShared) {
            this.subscriptionShared = subscriptionShared;
        }

        public Integer getPhase() {
            return this.phase;
        }

        public void setPhase(Integer phase) {
            this.phase = phase;
        }
    }
}

