/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.jms;

import com.azure.spring.autoconfigure.jms.AbstractServiceBusJMSAutoConfiguration;
import com.azure.spring.autoconfigure.jms.AzureServiceBusJMSProperties;
import com.azure.spring.autoconfigure.jms.SpringServiceBusJmsConnectionFactory;
import com.azure.spring.utils.ApplicationId;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import javax.jms.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ServiceBusJmsConnectionFactory.class})
@ConditionalOnResource(resources={"classpath:servicebusjms.enable.config"})
@ConditionalOnProperty(value={"spring.jms.servicebus.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="'${spring.jms.servicebus.pricing-tier}'.equalsIgnoreCase('premium')")
@EnableConfigurationProperties(value={AzureServiceBusJMSProperties.class})
public class PremiumServiceBusJMSAutoConfiguration
extends AbstractServiceBusJMSAutoConfiguration {
    public PremiumServiceBusJMSAutoConfiguration(AzureServiceBusJMSProperties azureServiceBusJMSProperties) {
        super(azureServiceBusJMSProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory jmsConnectionFactory() {
        String connectionString = this.azureServiceBusJMSProperties.getConnectionString();
        String clientId = this.azureServiceBusJMSProperties.getTopicClientId();
        int idleTimeout = this.azureServiceBusJMSProperties.getIdleTimeout();
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings((long)idleTimeout, false);
        settings.setShouldReconnect(false);
        SpringServiceBusJmsConnectionFactory springServiceBusJmsConnectionFactory = new SpringServiceBusJmsConnectionFactory(connectionString, settings);
        springServiceBusJmsConnectionFactory.setClientId(clientId);
        springServiceBusJmsConnectionFactory.setCustomUserAgent(ApplicationId.AZURE_SPRING_SERVICE_BUS);
        return springServiceBusJmsConnectionFactory;
    }
}

