/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.xml.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlDocumentDescriptor;
import com.buschmais.jqassistant.plugin.xml.api.model.XmlFileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public abstract class AbstractXmlFileScannerPlugin<D extends XmlFileDescriptor>
extends AbstractScannerPlugin<FileResource, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXmlFileScannerPlugin.class);

    public Class<? extends FileResource> getType() {
        return FileResource.class;
    }

    public Class<D> getDescriptorType() {
        return this.getTypeParameter(AbstractXmlFileScannerPlugin.class, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        FileDescriptor fileDescriptor = (FileDescriptor)scanner.getContext().getCurrentDescriptor();
        Class<D> descriptorType = this.getDescriptorType();
        XmlFileDescriptor xmlFileDescriptor = (XmlFileDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)fileDescriptor, descriptorType);
        scanner.getContext().push(XmlDocumentDescriptor.class, (Object)xmlFileDescriptor);
        try (InputStream stream = item.createStream();){
            scanner.scan((Object)new StreamSource(stream), path, scope);
        }
        finally {
            scanner.getContext().pop(XmlDocumentDescriptor.class);
        }
        if (xmlFileDescriptor.isXmlWellFormed()) {
            return (D)this.scan(item, xmlFileDescriptor, path, scope, scanner);
        }
        LOGGER.warn("XML content is not well-formed for item '{}', skipping.", (Object)path);
        return (D)xmlFileDescriptor;
    }

    public abstract D scan(FileResource var1, D var2, String var3, Scope var4, Scanner var5) throws IOException;
}

