/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class FastPushbackReader
extends FilterReader {
    private static final int SNIPPET_LENGTH = 200;
    private final int[] buf;
    private final int[] snippet;
    private int idx;
    protected int line;
    protected int col;
    private int snippetLoc = 0;

    FastPushbackReader(Reader reader, int size) {
        super(reader);
        if (size <= 0) {
            throw new JsonIoException("size <= 0");
        }
        this.buf = new int[size];
        this.idx = size;
        this.snippet = new int[200];
        this.line = 1;
        this.col = 0;
    }

    FastPushbackReader(Reader r) {
        this(r, 1);
    }

    String getLastSnippet() {
        StringBuilder s = new StringBuilder();
        int i = this.snippetLoc + 1;
        while (i < 200) {
            if (this.appendChar(s, i)) break;
            ++i;
        }
        i = 0;
        while (i <= this.snippetLoc) {
            if (this.appendChar(s, i)) break;
            ++i;
        }
        return s.toString();
    }

    private boolean appendChar(StringBuilder s, int i) {
        block3: {
            try {
                if (this.snippet[i] != 0) break block3;
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }
        s.appendCodePoint(this.snippet[i]);
        return false;
    }

    @Override
    public int read() throws IOException {
        int ch;
        int n = ch = this.idx < this.buf.length ? this.buf[this.idx++] : this.in.read();
        if (ch >= 0) {
            if (ch == 10) {
                ++this.line;
                this.col = 0;
            } else {
                ++this.col;
            }
            this.snippet[this.snippetLoc++] = ch;
            if (this.snippetLoc >= 200) {
                this.snippetLoc = 0;
            }
        }
        return ch;
    }

    public void unread(int c) throws IOException {
        if (this.idx == 0) {
            throw new JsonIoException("unread(int c) called more than buffer size (" + this.buf.length + ").  Increase FastPushbackReader's buffer size.  Currently " + this.buf.length);
        }
        if (c == 10) {
            --this.line;
        } else {
            --this.col;
        }
        this.buf[--this.idx] = c;
        --this.snippetLoc;
        if (this.snippetLoc < 0) {
            this.snippetLoc = 199;
        }
        this.snippet[this.snippetLoc] = c;
    }
}

