/*
 * Decompiled with CFR 0.152.
 */
package com.devskiller.friendly_id.spring;

import com.devskiller.friendly_id.FriendlyId;
import com.devskiller.friendly_id.jackson.FriendlyIdModule;
import com.fasterxml.jackson.databind.Module;
import java.util.UUID;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class FriendlyIdConfiguration
implements WebMvcConfigurer {
    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new StringToUuidConverter());
        registry.addConverter((Converter)new UuidToStringConverter());
    }

    @Bean
    public Module friendlyIdModule() {
        return new FriendlyIdModule();
    }

    public static class UuidToStringConverter
    implements Converter<UUID, String> {
        public String convert(UUID id) {
            return FriendlyId.toFriendlyId((UUID)id);
        }
    }

    public static class StringToUuidConverter
    implements Converter<String, UUID> {
        public UUID convert(String id) {
            return FriendlyId.toUuid((String)id);
        }
    }
}

