/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core;

import com.github.ckpoint.toexcel.core.ToWorkCell;
import com.github.ckpoint.toexcel.core.ToWorkSheet;
import com.github.ckpoint.toexcel.core.style.ToWorkBookStyle;
import com.github.ckpoint.toexcel.core.type.ToWorkBookType;
import com.github.ckpoint.toexcel.exception.SheetNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ToWorkBook {
    private final Workbook _wb;
    private final Map<ToWorkBookStyle, CellStyle> _styleMap = new HashMap<ToWorkBookStyle, CellStyle>();
    private final ToWorkBookType type;
    private List<ToWorkSheet> sheets = new ArrayList<ToWorkSheet>();

    public ToWorkBook(@NonNull ToWorkBookType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this._wb = type.createWorkBookInstance();
    }

    public ToWorkBook(@NonNull File file) throws IOException {
        this(ToWorkBookType.findWorkBookType(file.getName()), file);
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
    }

    public ToWorkBook(@NonNull ToWorkBookType type, @NonNull File file) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        this.type = type;
        this._wb = type.createWorkBookInstance(file);
        this.__initSheet();
    }

    public ToWorkBook(@NonNull ToWorkBookType type, @NonNull FileInputStream fis) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fis == null) {
            throw new NullPointerException("fis is marked non-null but is null");
        }
        this.type = type;
        this._wb = type.createWorkBookInstance(fis);
        this.__initSheet();
    }

    public ToWorkSheet createSheet() {
        ToWorkSheet sheet = new ToWorkSheet(this, this._wb);
        this.sheets.add(sheet);
        return sheet;
    }

    public ToWorkSheet createSheet(String name) {
        ToWorkSheet sheet = new ToWorkSheet(this, this._wb, name);
        this.sheets.add(sheet);
        return sheet;
    }

    public void write(@NonNull String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        String fp = this.type.translateFileName(filePath);
        File file = new File(fp);
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(fp);
        this._wb.write((OutputStream)fileOutputStream);
    }

    public String getFileName(String name) {
        if (this.type == null) {
            return name;
        }
        return this.type.translateFileName(name);
    }

    public void write(@NonNull OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        this._wb.write(outputStream);
    }

    public int sheetSize() {
        return this.sheets.size();
    }

    public ToWorkSheet getSheetAt(int idx) {
        return this.sheets.get(idx);
    }

    public ToWorkSheet getSheet(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.sheets.stream().filter(st -> name.equalsIgnoreCase(st.getName())).findFirst().orElseThrow(() -> new SheetNotFoundException("Not found sheet " + name));
    }

    public synchronized CellStyle createStyle(@NonNull ToWorkCell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        CellStyle cellStyle = this._styleMap.get(cell.getStyle());
        if (cellStyle != null) {
            return cellStyle;
        }
        cellStyle = cell.getStyle().convertOriginStyle(this._wb);
        this._styleMap.put(cell.getStyle(), cellStyle);
        return cellStyle;
    }

    private void __initSheet() {
        this.sheets = IntStream.range(0, this._wb.getNumberOfSheets()).mapToObj(arg_0 -> ((Workbook)this._wb).getSheetAt(arg_0)).map(sheet -> new ToWorkSheet(this, (Sheet)sheet)).collect(Collectors.toList());
    }

    public ToWorkBookType getType() {
        return this.type;
    }

    public List<ToWorkSheet> getSheets() {
        return this.sheets;
    }
}

