/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core;

import com.github.ckpoint.toexcel.core.ToWorkSheet;
import com.github.ckpoint.toexcel.core.style.ToWorkBookStyle;
import com.github.ckpoint.toexcel.core.type.ToWorkCellType;
import com.github.ckpoint.toexcel.util.ExcelHeaderHelper;
import java.util.Calendar;
import java.util.Date;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;

public class ToWorkCell
implements ExcelHeaderHelper {
    private final ToWorkSheet sheet;
    private final Cell _cell;
    private ToWorkBookStyle style;
    private ToWorkCellType cellType;

    public ToWorkCell(@NonNull ToWorkSheet sheet, @NonNull Cell cell, Object value) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        this.sheet = sheet;
        this._cell = cell;
        this.cellType = ToWorkCellType.VALUE;
        this.style = new ToWorkBookStyle(value);
        this._cell.setCellStyle(this.sheet.getWorkBook().createStyle(this));
        if (value == null) {
            return;
        }
        this.updateValue(value);
    }

    public ToWorkCell(@NonNull ToWorkSheet sheet, @NonNull Cell cell, Object value, @NonNull ToWorkBookStyle style) {
        this(sheet, cell, value);
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.style = style;
        this.cellType = ToWorkCellType.CUSTOM;
        this._cell.setCellStyle(this.sheet.getWorkBook().createStyle(this));
    }

    public ToWorkCell(@NonNull ToWorkSheet sheet, @NonNull Cell cell, Object value, @NonNull ToWorkCellType type) {
        this(sheet, cell, value);
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.cellType = type;
        if (type.isTitle()) {
            this.style.updateTitleType();
        }
        this._cell.setCellStyle(this.sheet.getWorkBook().createStyle(this));
    }

    public void updateStyle(@NonNull CellStyle cellStyle) {
        if (cellStyle == null) {
            throw new NullPointerException("cellStyle is marked non-null but is null");
        }
        this._cell.setCellStyle(cellStyle);
    }

    private ToWorkCell updateValue(Object value) {
        if (value instanceof Double) {
            this._cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            this._cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Long) {
            this._cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Boolean) {
            this._cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            this._cell.setCellValue((RichTextString)value);
        } else if (value instanceof Date) {
            this._cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            this._cell.setCellValue((Calendar)value);
        } else {
            this._cell.setCellValue(String.valueOf(value));
        }
        return this;
    }

    public ToWorkBookStyle getStyle() {
        return this.style;
    }
}

