/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core;

import com.github.ckpoint.toexcel.annotation.ExcelHeader;
import com.github.ckpoint.toexcel.core.ToWorkBook;
import com.github.ckpoint.toexcel.core.ToWorkCell;
import com.github.ckpoint.toexcel.core.converter.ExcelHeaderConverter;
import com.github.ckpoint.toexcel.core.converter.ExcelHeaderDefatulConverter;
import com.github.ckpoint.toexcel.core.model.CellPosition;
import com.github.ckpoint.toexcel.core.model.ToTitleKey;
import com.github.ckpoint.toexcel.core.style.ToWorkBookStyle;
import com.github.ckpoint.toexcel.core.type.SheetDirection;
import com.github.ckpoint.toexcel.core.type.ToWorkCellType;
import com.github.ckpoint.toexcel.exception.SheetNotFoundException;
import com.github.ckpoint.toexcel.util.ExcelHeaderHelper;
import com.github.ckpoint.toexcel.util.ModelMapperGenerator;
import com.github.ckpoint.toexcel.util.TitleRowHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class ToWorkSheet
implements ExcelHeaderHelper,
TitleRowHelper {
    private static final int DEFAULT_WIDTH_SIZE = 2560;
    private final ToWorkBook workBook;
    private final String name;
    private final Workbook _wb;
    private final CellPosition cellPosition;
    private ExcelHeaderConverter __excelHeaderConverter = new ExcelHeaderDefatulConverter();
    private Sheet _sheet;

    public ToWorkSheet(@NonNull ToWorkBook toWorkBook, @NonNull Workbook wb) {
        this(toWorkBook, wb, null);
        if (toWorkBook == null) {
            throw new NullPointerException("toWorkBook is marked non-null but is null");
        }
        if (wb == null) {
            throw new NullPointerException("wb is marked non-null but is null");
        }
    }

    public ToWorkSheet(@NonNull ToWorkBook toWorkBook, @NonNull Workbook wb, String name) {
        if (toWorkBook == null) {
            throw new NullPointerException("toWorkBook is marked non-null but is null");
        }
        if (wb == null) {
            throw new NullPointerException("wb is marked non-null but is null");
        }
        this.workBook = toWorkBook;
        this._wb = wb;
        if (name != null && !name.isEmpty()) {
            this.name = name;
            this._sheet = this._wb.createSheet(name);
        } else {
            this._sheet = this._wb.createSheet();
            this.name = this._sheet.getSheetName();
        }
        this.cellPosition = new CellPosition(this._sheet);
    }

    public ToWorkSheet(@NonNull ToWorkBook toWorkBook, @NonNull Sheet _sheet) {
        if (toWorkBook == null) {
            throw new NullPointerException("toWorkBook is marked non-null but is null");
        }
        if (_sheet == null) {
            throw new NullPointerException("_sheet is marked non-null but is null");
        }
        this.workBook = toWorkBook;
        this._wb = _sheet.getWorkbook();
        this._sheet = _sheet;
        this.name = _sheet.getSheetName();
        this.cellPosition = new CellPosition(_sheet);
    }

    public ToWorkSheet updateHeaderExcelConverter(ExcelHeaderConverter excelHeaderConverter) {
        this.__excelHeaderConverter = excelHeaderConverter;
        return this;
    }

    public List<ToWorkCell> createTitleCell(int width, String ... values) {
        if (values == null || values.length < 1) {
            return new ArrayList<ToWorkCell>();
        }
        ArrayList<ToWorkCell> cells = new ArrayList<ToWorkCell>();
        for (String value : values) {
            Cell pcell = this.cellPosition.nextCell();
            this._sheet.setColumnWidth(pcell.getColumnIndex(), 2560 * width);
            cells.add(new ToWorkCell(this, pcell, (Object)value, ToWorkCellType.TITLE));
        }
        return cells;
    }

    public List<ToWorkCell> createCellToNewline(Object ... values) {
        this.newLine();
        return this.createCell(values);
    }

    public List<ToWorkCell> createCell(@NonNull ToWorkBookStyle style, Object ... values) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        if (values == null || values.length < 1) {
            return new ArrayList<ToWorkCell>();
        }
        return Arrays.stream(values).map((? super T v) -> new ToWorkCell(this, this.cellPosition.nextCell(), v, style)).collect(Collectors.toList());
    }

    public List<ToWorkCell> createCell(Object ... values) {
        if (values == null || values.length < 1) {
            return new ArrayList<ToWorkCell>();
        }
        return Arrays.stream(values).map((? super T v) -> new ToWorkCell(this, this.cellPosition.nextCell(), v)).collect(Collectors.toList());
    }

    public void newLine() {
        this.cellPosition.newLine();
    }

    public <T> List<T> map(Class<T> type) {
        return this.map(type, null);
    }

    public <T> List<T> map(Class<T> type, Integer maxRowCnt) {
        Row titleRow = this.findTitleRow(type, this._sheet, this.__excelHeaderConverter);
        HashMap<Integer, String> excelTitleMap = new HashMap<Integer, String>();
        for (int i = 0; i < titleRow.getLastCellNum(); ++i) {
            excelTitleMap.put(i, titleRow.getCell(i) != null ? titleRow.getCell(i).getStringCellValue() : "");
        }
        List<String> existTitles = IntStream.range(0, titleRow.getLastCellNum()).mapToObj(arg_0 -> ((Row)titleRow).getCell(arg_0)).filter(Objects::nonNull).map(Cell::getStringCellValue).collect(Collectors.toList());
        List<Field> fields = this.getDeclaredFields(type);
        HashSet<ToTitleKey> keyset = new HashSet<ToTitleKey>();
        for (Field field : fields) {
            if (field.getAnnotation(ExcelHeader.class) == null) continue;
            keyset.add(new ToTitleKey(field, existTitles, this.__excelHeaderConverter));
        }
        List proxyMapList = IntStream.range(titleRow.getRowNum() + 1, this.getLastDataRowNum(titleRow, maxRowCnt)).mapToObj(arg_0 -> ((Sheet)this._sheet).getRow(arg_0)).map((? super T row) -> this.rowToMap((Row)row, (Map<Integer, String>)excelTitleMap, (Set<ToTitleKey>)keyset)).collect(Collectors.toList());
        return proxyMapList.stream().filter(map -> !this.isEmptyValueMap((Map<String, Object>)map)).map((? super T map) -> ModelMapperGenerator.enableFieldModelMapper().map(map, type)).collect(Collectors.toList());
    }

    private boolean isEmptyValueMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null || String.valueOf(entry.getValue()).trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int getLastDataRowNum(Row titleRow, Integer maxRowCnt) {
        if (maxRowCnt == null) {
            return this._sheet.getLastRowNum() + 1;
        }
        int firstDataRow = titleRow.getRowNum() + 1;
        return firstDataRow + maxRowCnt;
    }

    private List<Field> getDeclaredFields(Class type) {
        List<Field> fields = Arrays.stream(type.getDeclaredFields()).collect(Collectors.toList());
        if (type.getSuperclass() != null && !type.getSuperclass().equals(Object.class)) {
            fields.addAll(this.getDeclaredFields(type.getSuperclass()));
        }
        return fields;
    }

    public ToWorkSheet updateDirection(SheetDirection sheetDirection) {
        this.cellPosition.updateDirection(sheetDirection);
        return this;
    }

    public List<ToWorkCell> skip(int cnt) {
        List<Cell> cells = this.cellPosition.skip(cnt);
        return cells.stream().map((? super T v) -> new ToWorkCell(this, (Cell)v, null)).collect(Collectors.toList());
    }

    public void merge(int width, int height) {
        this.cellPosition.merge(width, height);
    }

    public void writeTitle(String title, int width) {
        this.createCell(title);
        this.merge(width, 1);
        this.newLine();
    }

    public void from(List list) {
        this.from(null, list);
    }

    public void from(String title, List list) {
        if (list == null || list.isEmpty()) {
            throw new SheetNotFoundException("Not found sheet list");
        }
        this.clear();
        Object obj = list.get(0);
        List<Field> fields = this.getDeclaredFields(obj.getClass());
        AtomicInteger fieldCount = new AtomicInteger();
        List<ToTitleKey> keys = fields.stream().filter(field -> field.getAnnotation(ExcelHeader.class) != null).map((? super T field) -> new ToTitleKey((Field)field, fieldCount.getAndIncrement(), this.__excelHeaderConverter)).sorted().collect(Collectors.toList());
        if (title != null) {
            this.writeTitle(title, keys.size());
        }
        keys.forEach(key -> this.createTitleCell(1, key.getViewName()));
        for (Object o : list) {
            this.writeObject(o, keys);
        }
    }

    public Cell getCell(@NonNull int rowIdx, @NonNull int cellIdx) {
        return this.cellPosition.getCell(rowIdx, cellIdx);
    }

    public List<CellRangeAddress> getMergedRegions() {
        if (this._sheet.getNumMergedRegions() < 1) {
            return new ArrayList<CellRangeAddress>();
        }
        return IntStream.range(0, this._sheet.getNumMergedRegions()).mapToObj(i -> this._sheet.getMergedRegion(i)).collect(Collectors.toList());
    }

    public int getRowCount() {
        if (this._sheet.getLastRowNum() == 0 && this._sheet.getRow(0) == null) {
            return 0;
        }
        return this._sheet.getLastRowNum() + 1;
    }

    private void writeObject(Object obj, List<ToTitleKey> keys) {
        this.newLine();
        keys.forEach(key -> {
            Object value = "";
            try {
                key.getField().setAccessible(true);
                value = key.getField().get(obj);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            this.createCell(value);
        });
    }

    private void clear() {
        for (int i = 0; i < this._sheet.getLastRowNum(); ++i) {
            this._sheet.removeRow(this._sheet.getRow(i));
        }
        this.cellPosition.clear();
    }

    private Map<String, Object> rowToMap(Row row, Map<Integer, String> titleMaps, Set<ToTitleKey> setKeys) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            Object value = this.getCellValue(row.getCell(i));
            String title = titleMaps.get(i);
            if (title == null) break;
            ToTitleKey toTitleKey = setKeys.stream().filter(key -> key.isMyName(title)).findFirst().orElse(null);
            if (toTitleKey == null) continue;
            valueMap.put(toTitleKey.getKey(), value);
        }
        return valueMap;
    }

    private Object getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 0: {
                return cell.getNumericCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 2: {
                return cell.getCachedFormulaResultType();
            }
            case 3: 
            case 5: {
                return "";
            }
        }
        return cell.getStringCellValue();
    }

    private Row getLastRow() {
        return this._sheet.getRow(this._sheet.getLastRowNum());
    }

    public ToWorkBook getWorkBook() {
        return this.workBook;
    }

    public String getName() {
        return this.name;
    }
}

