/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core.model;

import com.github.ckpoint.toexcel.core.type.SheetDirection;
import com.github.ckpoint.toexcel.exception.CellNotFoundException;
import com.github.ckpoint.toexcel.exception.RowNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CellPosition {
    private final Sheet _sheet;
    private int rowPosition;
    private int cellPosition;
    private SheetDirection sheetDirection;

    public CellPosition(@NonNull Sheet _sheet) {
        this(_sheet, SheetDirection.HORIZON);
        if (_sheet == null) {
            throw new NullPointerException("_sheet is marked non-null but is null");
        }
    }

    public CellPosition(@NonNull Sheet _sheet, SheetDirection sheetDirection) {
        if (_sheet == null) {
            throw new NullPointerException("_sheet is marked non-null but is null");
        }
        this._sheet = _sheet;
        this.sheetDirection = sheetDirection;
        if (this._sheet.getRow(0) == null) {
            this._sheet.createRow(0);
        }
    }

    public void newLine() {
        if (this.sheetDirection.equals((Object)SheetDirection.HORIZON)) {
            ++this.rowPosition;
            this.cellPosition = 0;
        } else {
            ++this.cellPosition;
            this.rowPosition = 0;
        }
    }

    public Cell nextCell() {
        Row currentRow = this._sheet.getRow(this.rowPosition);
        if (currentRow == null) {
            return this._sheet.createRow(this.rowPosition).createCell(this.cellPosition);
        }
        if (currentRow.getCell(this.cellPosition) == null) {
            return currentRow.createCell(this.cellPosition);
        }
        do {
            this.cellCountPlus();
            if (this._sheet.getRow(this.rowPosition) != null) continue;
            return this._sheet.createRow(this.rowPosition).createCell(this.cellPosition);
        } while (this._sheet.getRow(this.rowPosition).getCell(this.cellPosition) != null);
        return this._sheet.getRow(this.rowPosition).createCell(this.cellPosition);
    }

    public void clear() {
        this.rowPosition = 0;
        this.cellPosition = 0;
    }

    public SheetDirection updateDirection(SheetDirection sheetDirection) {
        this.sheetDirection = sheetDirection;
        return this.sheetDirection;
    }

    public List<Cell> skip(int cnt) {
        return IntStream.range(0, cnt).mapToObj(i -> this.nextCell()).collect(Collectors.toList());
    }

    public List<Cell> merge(int width, int height) {
        int targetCell = this.cellPosition + width - 1;
        int targetRow = this.rowPosition + height - 1;
        ArrayList<Cell> mergeCellList = new ArrayList<Cell>();
        Cell originCell = this._sheet.getRow(this.rowPosition) == null ? null : this._sheet.getRow(this.rowPosition).getCell(this.cellPosition);
        for (int rowIdx = this.rowPosition; rowIdx <= targetRow; ++rowIdx) {
            Row row = this._sheet.getRow(rowIdx) == null ? this._sheet.createRow(rowIdx) : this._sheet.getRow(rowIdx);
            for (int cellIdx = this.cellPosition; cellIdx <= targetCell; ++cellIdx) {
                if (row.getCell(cellIdx) == null) {
                    mergeCellList.add(row.createCell(cellIdx));
                    continue;
                }
                originCell = originCell != null ? originCell : row.getCell(cellIdx);
                mergeCellList.add(originCell);
            }
        }
        this._sheet.addMergedRegion(new CellRangeAddress(this.rowPosition, targetRow, this.cellPosition, targetCell));
        if (SheetDirection.HORIZON.equals((Object)this.sheetDirection)) {
            this.cellPosition = targetCell;
        } else {
            this.rowPosition = targetRow;
        }
        if (originCell != null) {
            for (Cell cell : mergeCellList) {
                this._sheet.setColumnWidth(cell.getColumnIndex(), this._sheet.getColumnWidth(originCell.getColumnIndex()));
                cell.setCellValue(originCell.getStringCellValue());
                cell.setCellStyle(originCell.getCellStyle());
            }
        }
        return mergeCellList;
    }

    public Cell getCell(@NonNull int rowIdx, @NonNull int cellIdx) {
        Row row = this._sheet.getRow(rowIdx);
        if (row == null) {
            throw new RowNotFoundException("Not found row index " + rowIdx);
        }
        Cell cell = row.getCell(cellIdx);
        if (cell == null) {
            throw new CellNotFoundException("Not found cell index " + cellIdx);
        }
        return cell;
    }

    private void cellCountPlus() {
        if (SheetDirection.HORIZON.equals((Object)this.sheetDirection)) {
            ++this.cellPosition;
        } else {
            ++this.rowPosition;
        }
    }
}

