/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core.model;

import com.github.ckpoint.toexcel.annotation.ExcelHeader;
import com.github.ckpoint.toexcel.core.converter.ExcelHeaderConverter;
import com.github.ckpoint.toexcel.util.ExcelHeaderHelper;
import java.lang.reflect.Field;
import java.util.List;
import lombok.NonNull;

public class ToTitleKey
implements ExcelHeaderHelper,
Comparable<ToTitleKey> {
    private String key;
    private String viewName;
    private ExcelHeader header;
    private Field field;
    private int priority;

    public ToTitleKey(@NonNull Field field, int fieldIdx, ExcelHeaderConverter excelHeaderConverter) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
        this.key = field.getName();
        this.header = field.getAnnotation(ExcelHeader.class);
        this.viewName = excelHeaderConverter.headerKeyConverter(this.header);
        this.priority = fieldIdx + this.header.priority() * 1000;
    }

    public ToTitleKey(Field field, List<String> titles, ExcelHeaderConverter excelHeaderConverter) {
        this.field = field;
        this.key = field.getName();
        ExcelHeader header = field.getAnnotation(ExcelHeader.class);
        List<String> headerStrs = this.headerList(header, excelHeaderConverter);
        this.viewName = headerStrs.stream().filter(titles::contains).findFirst().orElse(this.key);
    }

    public boolean isMyName(String title) {
        if (title == null) {
            return false;
        }
        return title.trim().equalsIgnoreCase(this.viewName.trim());
    }

    @Override
    public int compareTo(ToTitleKey o) {
        if (o.priority != this.priority) {
            return this.priority - o.priority;
        }
        return this.viewName.compareTo(o.viewName);
    }

    public String getKey() {
        return this.key;
    }

    public String getViewName() {
        return this.viewName;
    }

    public ExcelHeader getHeader() {
        return this.header;
    }

    public Field getField() {
        return this.field;
    }

    public int getPriority() {
        return this.priority;
    }
}

