/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core.style;

import lombok.NonNull;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class ToWorkBookFont {
    private String fontName;
    private Short fontHeight;
    private Short fontHeightInPoints;
    private Boolean italic;
    private Boolean strikeout;
    private Short color;
    private Short typeOffset;
    private Byte underline;
    private Integer charSet;
    private Short boldWeight;

    public Font convertFont(@NonNull Workbook wb) {
        if (wb == null) {
            throw new NullPointerException("wb is marked non-null but is null");
        }
        Font font = wb.createFont();
        if (this.fontName != null) {
            font.setFontName(this.fontName);
        }
        if (this.fontHeight != null) {
            font.setFontHeight(this.fontHeight.shortValue());
        }
        if (this.fontHeightInPoints != null) {
            font.setFontHeightInPoints(this.fontHeightInPoints.shortValue());
        }
        if (this.italic != null) {
            font.setItalic(this.italic.booleanValue());
        }
        if (this.strikeout != null) {
            font.setStrikeout(this.strikeout.booleanValue());
        }
        if (this.color != null) {
            font.setColor(this.color.shortValue());
        }
        if (this.typeOffset != null) {
            font.setTypeOffset(this.typeOffset.shortValue());
        }
        if (this.underline != null) {
            font.setUnderline(this.underline.byteValue());
        }
        if (this.charSet != null) {
            font.setCharSet(this.charSet.intValue());
        }
        if (this.boldWeight != null) {
            font.setBoldweight(this.boldWeight.shortValue());
        }
        return font;
    }

    ToWorkBookFont(String fontName, Short fontHeight, Short fontHeightInPoints, Boolean italic, Boolean strikeout, Short color, Short typeOffset, Byte underline, Integer charSet, Short boldWeight) {
        this.fontName = fontName;
        this.fontHeight = fontHeight;
        this.fontHeightInPoints = fontHeightInPoints;
        this.italic = italic;
        this.strikeout = strikeout;
        this.color = color;
        this.typeOffset = typeOffset;
        this.underline = underline;
        this.charSet = charSet;
        this.boldWeight = boldWeight;
    }

    public static ToWorkBookFontBuilder builder() {
        return new ToWorkBookFontBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToWorkBookFont)) {
            return false;
        }
        ToWorkBookFont other = (ToWorkBookFont)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fontName = this.fontName;
        String other$fontName = other.fontName;
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        Short this$fontHeight = this.fontHeight;
        Short other$fontHeight = other.fontHeight;
        if (this$fontHeight == null ? other$fontHeight != null : !((Object)this$fontHeight).equals(other$fontHeight)) {
            return false;
        }
        Short this$fontHeightInPoints = this.fontHeightInPoints;
        Short other$fontHeightInPoints = other.fontHeightInPoints;
        if (this$fontHeightInPoints == null ? other$fontHeightInPoints != null : !((Object)this$fontHeightInPoints).equals(other$fontHeightInPoints)) {
            return false;
        }
        Boolean this$italic = this.italic;
        Boolean other$italic = other.italic;
        if (this$italic == null ? other$italic != null : !((Object)this$italic).equals(other$italic)) {
            return false;
        }
        Boolean this$strikeout = this.strikeout;
        Boolean other$strikeout = other.strikeout;
        if (this$strikeout == null ? other$strikeout != null : !((Object)this$strikeout).equals(other$strikeout)) {
            return false;
        }
        Short this$color = this.color;
        Short other$color = other.color;
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        Short this$typeOffset = this.typeOffset;
        Short other$typeOffset = other.typeOffset;
        if (this$typeOffset == null ? other$typeOffset != null : !((Object)this$typeOffset).equals(other$typeOffset)) {
            return false;
        }
        Byte this$underline = this.underline;
        Byte other$underline = other.underline;
        if (this$underline == null ? other$underline != null : !((Object)this$underline).equals(other$underline)) {
            return false;
        }
        Integer this$charSet = this.charSet;
        Integer other$charSet = other.charSet;
        if (this$charSet == null ? other$charSet != null : !((Object)this$charSet).equals(other$charSet)) {
            return false;
        }
        Short this$boldWeight = this.boldWeight;
        Short other$boldWeight = other.boldWeight;
        return !(this$boldWeight == null ? other$boldWeight != null : !((Object)this$boldWeight).equals(other$boldWeight));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ToWorkBookFont;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fontName = this.fontName;
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        Short $fontHeight = this.fontHeight;
        result = result * 59 + ($fontHeight == null ? 43 : ((Object)$fontHeight).hashCode());
        Short $fontHeightInPoints = this.fontHeightInPoints;
        result = result * 59 + ($fontHeightInPoints == null ? 43 : ((Object)$fontHeightInPoints).hashCode());
        Boolean $italic = this.italic;
        result = result * 59 + ($italic == null ? 43 : ((Object)$italic).hashCode());
        Boolean $strikeout = this.strikeout;
        result = result * 59 + ($strikeout == null ? 43 : ((Object)$strikeout).hashCode());
        Short $color = this.color;
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        Short $typeOffset = this.typeOffset;
        result = result * 59 + ($typeOffset == null ? 43 : ((Object)$typeOffset).hashCode());
        Byte $underline = this.underline;
        result = result * 59 + ($underline == null ? 43 : ((Object)$underline).hashCode());
        Integer $charSet = this.charSet;
        result = result * 59 + ($charSet == null ? 43 : ((Object)$charSet).hashCode());
        Short $boldWeight = this.boldWeight;
        result = result * 59 + ($boldWeight == null ? 43 : ((Object)$boldWeight).hashCode());
        return result;
    }

    public static class ToWorkBookFontBuilder {
        private String fontName;
        private Short fontHeight;
        private Short fontHeightInPoints;
        private Boolean italic;
        private Boolean strikeout;
        private Short color;
        private Short typeOffset;
        private Byte underline;
        private Integer charSet;
        private Short boldWeight;

        ToWorkBookFontBuilder() {
        }

        public ToWorkBookFontBuilder fontName(String fontName) {
            this.fontName = fontName;
            return this;
        }

        public ToWorkBookFontBuilder fontHeight(Short fontHeight) {
            this.fontHeight = fontHeight;
            return this;
        }

        public ToWorkBookFontBuilder fontHeightInPoints(Short fontHeightInPoints) {
            this.fontHeightInPoints = fontHeightInPoints;
            return this;
        }

        public ToWorkBookFontBuilder italic(Boolean italic) {
            this.italic = italic;
            return this;
        }

        public ToWorkBookFontBuilder strikeout(Boolean strikeout) {
            this.strikeout = strikeout;
            return this;
        }

        public ToWorkBookFontBuilder color(Short color) {
            this.color = color;
            return this;
        }

        public ToWorkBookFontBuilder typeOffset(Short typeOffset) {
            this.typeOffset = typeOffset;
            return this;
        }

        public ToWorkBookFontBuilder underline(Byte underline) {
            this.underline = underline;
            return this;
        }

        public ToWorkBookFontBuilder charSet(Integer charSet) {
            this.charSet = charSet;
            return this;
        }

        public ToWorkBookFontBuilder boldWeight(Short boldWeight) {
            this.boldWeight = boldWeight;
            return this;
        }

        public ToWorkBookFont build() {
            return new ToWorkBookFont(this.fontName, this.fontHeight, this.fontHeightInPoints, this.italic, this.strikeout, this.color, this.typeOffset, this.underline, this.charSet, this.boldWeight);
        }

        public String toString() {
            return "ToWorkBookFont.ToWorkBookFontBuilder(fontName=" + this.fontName + ", fontHeight=" + this.fontHeight + ", fontHeightInPoints=" + this.fontHeightInPoints + ", italic=" + this.italic + ", strikeout=" + this.strikeout + ", color=" + this.color + ", typeOffset=" + this.typeOffset + ", underline=" + this.underline + ", charSet=" + this.charSet + ", boldWeight=" + this.boldWeight + ")";
        }
    }
}

