/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core.style;

import com.github.ckpoint.toexcel.core.style.ToWorkBookFont;
import java.util.Calendar;
import java.util.Date;
import lombok.NonNull;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ToWorkBookStyle {
    private HorizontalAlignment alignment = HorizontalAlignment.CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;
    private BorderStyle borderTop = BorderStyle.THIN;
    private BorderStyle borderBottom = BorderStyle.THIN;
    private BorderStyle borderLeft = BorderStyle.THIN;
    private BorderStyle borderRight = BorderStyle.THIN;
    private Short fillPattern;
    private IndexedColors fillForegroundColor;
    private IndexedColors fillBackgroundColor;
    private ToWorkBookFont font;
    private Short format = 0;
    private Boolean hidden;
    private Boolean locked;
    private Boolean wrapText;
    private Short rotation;
    private Short indention;
    private IndexedColors boardColorTop = IndexedColors.BLACK;
    private IndexedColors boardColorBottom = IndexedColors.BLACK;
    private IndexedColors boardColorLeft = IndexedColors.BLACK;
    private IndexedColors boardColorRight = IndexedColors.BLACK;

    public ToWorkBookStyle() {
        this(null);
    }

    public ToWorkBookStyle(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short) {
            this.updateNumberType();
        } else if (obj instanceof Double || obj instanceof Float) {
            this.updateNumberType();
        } else if (obj instanceof Date || obj instanceof Calendar) {
            this.updateDateType();
        } else {
            return;
        }
    }

    public ToWorkBookStyle updateNumberType() {
        this.updateformat("#,##0");
        this.alignment = HorizontalAlignment.RIGHT;
        return this;
    }

    public ToWorkBookStyle updateDateType() {
        this.format = 14;
        return this;
    }

    public ToWorkBookStyle updateTitleType() {
        this.fillForegroundColor = IndexedColors.GREY_25_PERCENT;
        this.fillPattern = 1;
        this.font = ToWorkBookFont.builder().boldWeight((short)700).fontHeightInPoints((short)12).build();
        return this;
    }

    public void updateformat(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = HSSFDataFormat.getBuiltinFormat((String)format);
    }

    public void updateformat(short format) {
        this.format = format;
    }

    public void updateBoardColorAll(IndexedColors colors) {
        this.boardColorTop = colors;
        this.boardColorBottom = colors;
        this.boardColorLeft = colors;
        this.boardColorRight = colors;
    }

    public void updateBoardAll(BorderStyle borderStyle) {
        this.borderTop = borderStyle;
        this.borderBottom = borderStyle;
        this.borderLeft = borderStyle;
        this.borderRight = borderStyle;
    }

    public CellStyle convertOriginStyle(@NonNull Workbook wb) {
        if (wb == null) {
            throw new NullPointerException("wb is marked non-null but is null");
        }
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment((short)this.alignment.ordinal());
        cellStyle.setVerticalAlignment((short)this.verticalAlignment.ordinal());
        cellStyle.setBorderTop((short)this.borderTop.ordinal());
        cellStyle.setBorderBottom((short)this.borderBottom.ordinal());
        cellStyle.setBorderLeft((short)this.borderLeft.ordinal());
        cellStyle.setBorderRight((short)this.borderRight.ordinal());
        cellStyle.setTopBorderColor(this.boardColorTop.getIndex());
        cellStyle.setBottomBorderColor(this.boardColorBottom.getIndex());
        cellStyle.setLeftBorderColor(this.boardColorLeft.getIndex());
        cellStyle.setRightBorderColor(this.boardColorRight.getIndex());
        cellStyle.setDataFormat(this.format.shortValue());
        if (this.fillForegroundColor != null) {
            cellStyle.setFillForegroundColor(this.fillForegroundColor.getIndex());
        }
        if (this.fillBackgroundColor != null) {
            cellStyle.setFillBackgroundColor(this.fillBackgroundColor.getIndex());
        }
        if (this.fillPattern != null) {
            cellStyle.setFillPattern(this.fillPattern.shortValue());
        }
        if (this.font != null) {
            cellStyle.setFont(this.font.convertFont(wb));
        }
        if (this.hidden != null) {
            cellStyle.setHidden(this.hidden.booleanValue());
        }
        if (this.locked != null) {
            cellStyle.setLocked(this.locked.booleanValue());
        }
        if (this.wrapText != null) {
            cellStyle.setWrapText(this.wrapText.booleanValue());
        }
        if (this.rotation != null) {
            cellStyle.setRotation(this.rotation.shortValue());
        }
        if (this.indention != null) {
            cellStyle.setIndention(this.indention.shortValue());
        }
        return cellStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToWorkBookStyle)) {
            return false;
        }
        ToWorkBookStyle other = (ToWorkBookStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HorizontalAlignment this$alignment = this.getAlignment();
        HorizontalAlignment other$alignment = other.getAlignment();
        if (this$alignment == null ? other$alignment != null : !this$alignment.equals(other$alignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        if (this$verticalAlignment == null ? other$verticalAlignment != null : !this$verticalAlignment.equals(other$verticalAlignment)) {
            return false;
        }
        BorderStyle this$borderTop = this.getBorderTop();
        BorderStyle other$borderTop = other.getBorderTop();
        if (this$borderTop == null ? other$borderTop != null : !this$borderTop.equals(other$borderTop)) {
            return false;
        }
        BorderStyle this$borderBottom = this.getBorderBottom();
        BorderStyle other$borderBottom = other.getBorderBottom();
        if (this$borderBottom == null ? other$borderBottom != null : !this$borderBottom.equals(other$borderBottom)) {
            return false;
        }
        BorderStyle this$borderLeft = this.getBorderLeft();
        BorderStyle other$borderLeft = other.getBorderLeft();
        if (this$borderLeft == null ? other$borderLeft != null : !this$borderLeft.equals(other$borderLeft)) {
            return false;
        }
        BorderStyle this$borderRight = this.getBorderRight();
        BorderStyle other$borderRight = other.getBorderRight();
        if (this$borderRight == null ? other$borderRight != null : !this$borderRight.equals(other$borderRight)) {
            return false;
        }
        Short this$fillPattern = this.getFillPattern();
        Short other$fillPattern = other.getFillPattern();
        if (this$fillPattern == null ? other$fillPattern != null : !((Object)this$fillPattern).equals(other$fillPattern)) {
            return false;
        }
        IndexedColors this$fillForegroundColor = this.getFillForegroundColor();
        IndexedColors other$fillForegroundColor = other.getFillForegroundColor();
        if (this$fillForegroundColor == null ? other$fillForegroundColor != null : !this$fillForegroundColor.equals(other$fillForegroundColor)) {
            return false;
        }
        IndexedColors this$fillBackgroundColor = this.getFillBackgroundColor();
        IndexedColors other$fillBackgroundColor = other.getFillBackgroundColor();
        if (this$fillBackgroundColor == null ? other$fillBackgroundColor != null : !this$fillBackgroundColor.equals(other$fillBackgroundColor)) {
            return false;
        }
        ToWorkBookFont this$font = this.getFont();
        ToWorkBookFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        Short this$format = this.getFormat();
        Short other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)this$format).equals(other$format)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        if (this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked)) {
            return false;
        }
        Boolean this$wrapText = this.getWrapText();
        Boolean other$wrapText = other.getWrapText();
        if (this$wrapText == null ? other$wrapText != null : !((Object)this$wrapText).equals(other$wrapText)) {
            return false;
        }
        Short this$rotation = this.getRotation();
        Short other$rotation = other.getRotation();
        if (this$rotation == null ? other$rotation != null : !((Object)this$rotation).equals(other$rotation)) {
            return false;
        }
        Short this$indention = this.getIndention();
        Short other$indention = other.getIndention();
        if (this$indention == null ? other$indention != null : !((Object)this$indention).equals(other$indention)) {
            return false;
        }
        IndexedColors this$boardColorTop = this.getBoardColorTop();
        IndexedColors other$boardColorTop = other.getBoardColorTop();
        if (this$boardColorTop == null ? other$boardColorTop != null : !this$boardColorTop.equals(other$boardColorTop)) {
            return false;
        }
        IndexedColors this$boardColorBottom = this.getBoardColorBottom();
        IndexedColors other$boardColorBottom = other.getBoardColorBottom();
        if (this$boardColorBottom == null ? other$boardColorBottom != null : !this$boardColorBottom.equals(other$boardColorBottom)) {
            return false;
        }
        IndexedColors this$boardColorLeft = this.getBoardColorLeft();
        IndexedColors other$boardColorLeft = other.getBoardColorLeft();
        if (this$boardColorLeft == null ? other$boardColorLeft != null : !this$boardColorLeft.equals(other$boardColorLeft)) {
            return false;
        }
        IndexedColors this$boardColorRight = this.getBoardColorRight();
        IndexedColors other$boardColorRight = other.getBoardColorRight();
        return !(this$boardColorRight == null ? other$boardColorRight != null : !this$boardColorRight.equals(other$boardColorRight));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ToWorkBookStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HorizontalAlignment $alignment = this.getAlignment();
        result = result * 59 + ($alignment == null ? 43 : $alignment.hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : $verticalAlignment.hashCode());
        BorderStyle $borderTop = this.getBorderTop();
        result = result * 59 + ($borderTop == null ? 43 : $borderTop.hashCode());
        BorderStyle $borderBottom = this.getBorderBottom();
        result = result * 59 + ($borderBottom == null ? 43 : $borderBottom.hashCode());
        BorderStyle $borderLeft = this.getBorderLeft();
        result = result * 59 + ($borderLeft == null ? 43 : $borderLeft.hashCode());
        BorderStyle $borderRight = this.getBorderRight();
        result = result * 59 + ($borderRight == null ? 43 : $borderRight.hashCode());
        Short $fillPattern = this.getFillPattern();
        result = result * 59 + ($fillPattern == null ? 43 : ((Object)$fillPattern).hashCode());
        IndexedColors $fillForegroundColor = this.getFillForegroundColor();
        result = result * 59 + ($fillForegroundColor == null ? 43 : $fillForegroundColor.hashCode());
        IndexedColors $fillBackgroundColor = this.getFillBackgroundColor();
        result = result * 59 + ($fillBackgroundColor == null ? 43 : $fillBackgroundColor.hashCode());
        ToWorkBookFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        Short $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)$format).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        Boolean $wrapText = this.getWrapText();
        result = result * 59 + ($wrapText == null ? 43 : ((Object)$wrapText).hashCode());
        Short $rotation = this.getRotation();
        result = result * 59 + ($rotation == null ? 43 : ((Object)$rotation).hashCode());
        Short $indention = this.getIndention();
        result = result * 59 + ($indention == null ? 43 : ((Object)$indention).hashCode());
        IndexedColors $boardColorTop = this.getBoardColorTop();
        result = result * 59 + ($boardColorTop == null ? 43 : $boardColorTop.hashCode());
        IndexedColors $boardColorBottom = this.getBoardColorBottom();
        result = result * 59 + ($boardColorBottom == null ? 43 : $boardColorBottom.hashCode());
        IndexedColors $boardColorLeft = this.getBoardColorLeft();
        result = result * 59 + ($boardColorLeft == null ? 43 : $boardColorLeft.hashCode());
        IndexedColors $boardColorRight = this.getBoardColorRight();
        result = result * 59 + ($boardColorRight == null ? 43 : $boardColorRight.hashCode());
        return result;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public Short getFillPattern() {
        return this.fillPattern;
    }

    public IndexedColors getFillForegroundColor() {
        return this.fillForegroundColor;
    }

    public IndexedColors getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public ToWorkBookFont getFont() {
        return this.font;
    }

    public Short getFormat() {
        return this.format;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Boolean getWrapText() {
        return this.wrapText;
    }

    public Short getRotation() {
        return this.rotation;
    }

    public Short getIndention() {
        return this.indention;
    }

    public IndexedColors getBoardColorTop() {
        return this.boardColorTop;
    }

    public IndexedColors getBoardColorBottom() {
        return this.boardColorBottom;
    }

    public IndexedColors getBoardColorLeft() {
        return this.boardColorLeft;
    }

    public IndexedColors getBoardColorRight() {
        return this.boardColorRight;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setBorderTop(BorderStyle borderTop) {
        this.borderTop = borderTop;
    }

    public void setBorderBottom(BorderStyle borderBottom) {
        this.borderBottom = borderBottom;
    }

    public void setBorderLeft(BorderStyle borderLeft) {
        this.borderLeft = borderLeft;
    }

    public void setBorderRight(BorderStyle borderRight) {
        this.borderRight = borderRight;
    }

    public void setFillPattern(Short fillPattern) {
        this.fillPattern = fillPattern;
    }

    public void setFillForegroundColor(IndexedColors fillForegroundColor) {
        this.fillForegroundColor = fillForegroundColor;
    }

    public void setFillBackgroundColor(IndexedColors fillBackgroundColor) {
        this.fillBackgroundColor = fillBackgroundColor;
    }

    public void setFont(ToWorkBookFont font) {
        this.font = font;
    }

    public void setFormat(Short format) {
        this.format = format;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setWrapText(Boolean wrapText) {
        this.wrapText = wrapText;
    }

    public void setRotation(Short rotation) {
        this.rotation = rotation;
    }

    public void setIndention(Short indention) {
        this.indention = indention;
    }

    public void setBoardColorTop(IndexedColors boardColorTop) {
        this.boardColorTop = boardColorTop;
    }

    public void setBoardColorBottom(IndexedColors boardColorBottom) {
        this.boardColorBottom = boardColorBottom;
    }

    public void setBoardColorLeft(IndexedColors boardColorLeft) {
        this.boardColorLeft = boardColorLeft;
    }

    public void setBoardColorRight(IndexedColors boardColorRight) {
        this.boardColorRight = boardColorRight;
    }
}

