/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.core.type;

import com.github.ckpoint.toexcel.exception.NotFoundExtException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public enum ToWorkBookType {
    HSSF("xls"),
    XSSF("xlsx");

    private final String ext;

    private ToWorkBookType(String ext) {
        this.ext = ext;
    }

    public Workbook createWorkBookInstance() {
        if (this.equals((Object)HSSF)) {
            return new HSSFWorkbook();
        }
        return new XSSFWorkbook();
    }

    public static ToWorkBookType findWorkBookType(@NonNull String ext) {
        if (ext == null) {
            throw new NullPointerException("ext is marked non-null but is null");
        }
        return Arrays.stream(ToWorkBookType.values()).filter(type -> ext.endsWith(type.ext)).findFirst().orElseThrow(() -> new NotFoundExtException(ext + " is not supported"));
    }

    public Workbook createWorkBookInstance(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileInputStream fis = new FileInputStream(file);
        return this.createWorkBookInstance(fis);
    }

    public Workbook createWorkBookInstance(@NonNull FileInputStream fis) throws IOException {
        if (fis == null) {
            throw new NullPointerException("fis is marked non-null but is null");
        }
        if (this.equals((Object)HSSF)) {
            return new HSSFWorkbook((InputStream)fis);
        }
        return new XSSFWorkbook((InputStream)fis);
    }

    public String translateFileName(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        String _fp = filename;
        if (_fp.lastIndexOf(".") > 0) {
            _fp = _fp.substring(0, _fp.indexOf("."));
        }
        return _fp + "." + this.ext;
    }
}

