/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.util;

import com.github.ckpoint.toexcel.annotation.ExcelHeader;
import com.github.ckpoint.toexcel.core.converter.ExcelHeaderConverter;
import com.github.ckpoint.toexcel.util.TypeExcelFormatMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public interface ExcelHeaderHelper {
    default public CellStyle getCellStyle(@NonNull Workbook workbook, ExcelHeader option, Class fieldType) {
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        CellStyle style = workbook.createCellStyle();
        if (option != null) {
            style.setAlignment((short)option.alignment().ordinal());
            style.setVerticalAlignment((short)option.verticalAlignment().ordinal());
        } else {
            style.setAlignment((short)2);
            style.setVerticalAlignment((short)1);
        }
        style.setBorderTop((short)1);
        style.setBorderRight((short)1);
        style.setBorderLeft((short)1);
        style.setBorderBottom((short)1);
        style.setDataFormat(option.format() >= 0 ? option.format() : TypeExcelFormatMap.findFormat(fieldType));
        return style;
    }

    default public List<String> headerList(@NonNull ExcelHeader header, ExcelHeaderConverter excelHeaderConverter) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(header.headerName());
        if (!header.headerName().equals(excelHeaderConverter.headerKeyConverter(header))) {
            headers.add(excelHeaderConverter.headerKeyConverter(header));
        }
        headers.addAll(Arrays.asList(header.headerNames()));
        return headers.stream().filter(Objects::nonNull).map(String::trim).filter(hd -> !hd.isEmpty()).collect(Collectors.toList());
    }
}

