/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.util;

import com.github.ckpoint.toexcel.util.mapper.DoubleToDateConverter;
import com.github.ckpoint.toexcel.util.mapper.DoubleToStringConverter;
import com.github.ckpoint.toexcel.util.mapper.StringToDateConverter;
import com.github.ckpoint.toexcel.util.mapper.StringToStringConverter;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.config.Configuration;
import org.modelmapper.convention.MatchingStrategies;

public class ModelMapperGenerator {
    public static ModelMapper defaultModelMapper() {
        ModelMapper mapper = new ModelMapper();
        mapper.addConverter((Converter)new DoubleToDateConverter());
        mapper.addConverter((Converter)new StringToDateConverter());
        mapper.addConverter((Converter)new StringToStringConverter());
        mapper.addConverter((Converter)new DoubleToStringConverter());
        return mapper;
    }

    public static ModelMapper strictModelMapper() {
        ModelMapper modelMapper = ModelMapperGenerator.defaultModelMapper();
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT);
        return modelMapper;
    }

    public static ModelMapper enableFieldModelMapper(Configuration.AccessLevel accessLevel) {
        ModelMapper modelMapper = ModelMapperGenerator.strictModelMapper();
        modelMapper.getConfiguration().setFieldMatchingEnabled(true);
        modelMapper.getConfiguration().setFieldAccessLevel(accessLevel);
        return modelMapper;
    }

    public static ModelMapper enableFieldModelMapper() {
        return ModelMapperGenerator.enableFieldModelMapper(Configuration.AccessLevel.PRIVATE);
    }
}

