/*
 * Decompiled with CFR 0.152.
 */
package com.github.ckpoint.toexcel.util;

import com.github.ckpoint.toexcel.annotation.ExcelHeader;
import com.github.ckpoint.toexcel.core.converter.ExcelHeaderConverter;
import com.github.ckpoint.toexcel.util.ExcelHeaderHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public interface TitleRowHelper
extends ExcelHeaderHelper {
    default public Row findTitleRow(@NonNull Class type, @NonNull Sheet sheet, @NonNull ExcelHeaderConverter excelHeaderConverter) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (excelHeaderConverter == null) {
            throw new NullPointerException("excelHeaderConverter is marked non-null but is null");
        }
        Field[] fields = type.getDeclaredFields();
        ArrayList<String> titles = new ArrayList<String>();
        Arrays.stream(fields).map(fd -> fd.getAnnotation(ExcelHeader.class)).filter(Objects::nonNull).map(fd -> this.headerList((ExcelHeader)fd, excelHeaderConverter)).forEach(titles::addAll);
        int maxSearchRow = sheet.getLastRowNum() < 100 ? sheet.getLastRowNum() : 100;
        int maxCnt = 0;
        Row titleRow = null;
        for (int i = 0; i < maxSearchRow; ++i) {
            Row tmpRow = sheet.getRow(i);
            int cnt = this.countMatchTitles(tmpRow, titles);
            if (cnt <= maxCnt) continue;
            titleRow = tmpRow;
        }
        return titleRow == null ? sheet.getRow(0) : titleRow;
    }

    default public int countMatchTitles(Row row, List<String> titles) {
        int count = 0;
        if (row == null) {
            return 0;
        }
        for (short i = 0; i < row.getLastCellNum(); i = (short)(i + 1)) {
            String cellStr;
            Cell cell = row.getCell((int)i);
            if (cell == null || cell.getCellType() != 1 || (cellStr = cell.getStringCellValue()) == null) continue;
            count += titles.contains(cellStr.trim()) ? 1 : 0;
        }
        return count;
    }
}

