/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import redis.embedded.Redis;
import redis.embedded.util.IO;

public abstract class RedisInstance
implements Redis {
    private final Pattern readyPattern;
    private final int port;
    private final List<String> args;
    private final boolean forceStop;
    private final Consumer<String> soutListener;
    private final Consumer<String> serrListener;
    private volatile boolean active = false;
    private Process process;

    protected RedisInstance(int port, List<String> args, Pattern readyPattern, boolean forceStop, Consumer<String> soutListener, Consumer<String> serrListener) {
        this.port = port;
        this.args = args;
        this.readyPattern = readyPattern;
        this.forceStop = forceStop;
        this.soutListener = soutListener;
        this.serrListener = serrListener;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.active) {
            return;
        }
        try {
            this.process = new ProcessBuilder(this.args).directory(new File(this.args.get(0)).getParentFile()).start();
            IO.addShutdownHook("RedisInstanceCleaner", IO.checkedToRuntime(this::stop));
            RedisInstance.awaitServerReady(this.process, this.readyPattern, this.soutListener, this.serrListener);
            if (this.serrListener != null) {
                IO.newDaemonThread(() -> IO.logStream(this.process.getErrorStream(), this.serrListener)).start();
            }
            if (this.soutListener != null) {
                IO.newDaemonThread(() -> IO.logStream(this.process.getInputStream(), this.soutListener)).start();
            }
            this.active = true;
        }
        catch (IOException e) {
            throw new IOException("Failed to start Redis service", e);
        }
    }

    private static void awaitServerReady(Process process, Pattern readyPattern, Consumer<String> soutListener, Consumer<String> serrListener) throws IOException {
        StringBuilder log = new StringBuilder();
        if (!IO.findMatchInStream(process.getInputStream(), readyPattern, soutListener, log)) {
            String stdOut = log.toString();
            String stdErr = IO.readFully(process.getErrorStream(), serrListener);
            throw new IOException("Redis-server process appears not to have started. " + (RedisInstance.isNullOrEmpty(stdOut) ? "No output was found in standard-out." : "stdandard-out contains this: " + stdOut) + " " + (RedisInstance.isNullOrEmpty(stdErr) ? "No output was found in standard-err." : "stdandard-err contains this: " + stdErr));
        }
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @Override
    public synchronized void stop() throws IOException {
        if (!this.active) {
            return;
        }
        try {
            if (this.forceStop) {
                this.process.destroyForcibly();
            } else {
                this.process.destroy();
                this.process.waitFor();
            }
            this.active = false;
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to stop redis service", e);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public List<Integer> ports() {
        return Collections.singletonList(this.port);
    }
}

