/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.subpackage;

import com.github.dcendents.mybatis.generator.plugin.subpackage.RenameProperties;
import java.beans.ConstructorProperties;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSubPackagePlugin
extends PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(CreateSubPackagePlugin.class);
    public static final String MODEL_PACKAGE_PROPERTY = "modelSubPackage";
    public static final String MODEL_CLASS_SUFFIX_PROPERTY = "modelClassSuffix";
    public static final String MAPPER_PACKAGE_PROPERTY = "mapperSubPackage";
    public static final String MAPPER_CLASS_SUFFIX_PROPERTY = "mapperClassSuffix";
    public static final String EXAMPLE_PACKAGE_PROPERTY = "exampleSubPackage";
    public static final String EXAMPLE_CLASS_SUFFIX_PROPERTY = "exampleClassSuffix";
    static final String ATTRIBUTE_NAMESPACE = "namespace";
    static final String ATTRIBUTE_TYPE = "type";
    private RenameProperties modelProperties;
    private RenameProperties mapperProperties;
    private RenameProperties exampleProperties;

    public CreateSubPackagePlugin() {
        this.modelProperties = new RenameProperties();
        this.mapperProperties = new RenameProperties();
        this.exampleProperties = new RenameProperties();
    }

    public boolean validate(List<String> warnings) {
        this.modelProperties.validate(this.properties.getProperty(MODEL_PACKAGE_PROPERTY), this.properties.getProperty(MODEL_CLASS_SUFFIX_PROPERTY));
        this.mapperProperties.validate(this.properties.getProperty(MAPPER_PACKAGE_PROPERTY), this.properties.getProperty(MAPPER_CLASS_SUFFIX_PROPERTY));
        this.exampleProperties.validate(this.properties.getProperty(EXAMPLE_PACKAGE_PROPERTY), this.properties.getProperty(EXAMPLE_CLASS_SUFFIX_PROPERTY));
        return this.modelProperties.isEnabled() || this.mapperProperties.isEnabled() || this.exampleProperties.isEnabled();
    }

    public void initialized(IntrospectedTable introspectedTable) {
        introspectedTable.setBaseRecordType(this.modelProperties.setTypes(introspectedTable.getBaseRecordType()));
        introspectedTable.setMyBatis3JavaMapperType(this.mapperProperties.setTypes(introspectedTable.getMyBatis3JavaMapperType()));
        introspectedTable.setExampleType(this.exampleProperties.setTypes(introspectedTable.getExampleType()));
    }

    boolean renameMethod(Method method) {
        method.setReturnType(this.modelProperties.renameType(method.getReturnType()));
        for (int i = 0; i < method.getParameters().size(); ++i) {
            FullyQualifiedJavaType newParameterType;
            Parameter parameter = (Parameter)method.getParameters().get(i);
            FullyQualifiedJavaType parameterType = parameter.getType();
            if (parameterType == (newParameterType = this.modelProperties.renameType(parameterType))) continue;
            Parameter newParam = new Parameter(newParameterType, parameter.getName(), parameter.isVarargs());
            for (String annotation : parameter.getAnnotations()) {
                newParam.addAnnotation(annotation);
            }
            method.getParameters().set(i, newParam);
            log.debug("set new parameter: [{}][{}]", (Object)parameter, (Object)newParam);
        }
        return true;
    }

    boolean renameElementAttribute(XmlElement element, String attributeName) {
        for (int i = 0; i < element.getAttributes().size(); ++i) {
            Attribute attribute = (Attribute)element.getAttributes().get(i);
            if (!attributeName.equals(attribute.getName())) continue;
            element.getAttributes().set(i, this.modelProperties.renameAttribute((Attribute)element.getAttributes().get(i)));
            element.getAttributes().set(i, this.mapperProperties.renameAttribute((Attribute)element.getAttributes().get(i)));
        }
        return true;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        return this.renameElementAttribute(document.getRootElement(), ATTRIBUTE_NAMESPACE);
    }

    public boolean sqlMapResultMapWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.renameElementAttribute(element, ATTRIBUTE_TYPE);
    }

    public boolean sqlMapResultMapWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return this.renameElementAttribute(element, ATTRIBUTE_TYPE);
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientCountByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientCountByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientInsertMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType modelType = new FullyQualifiedJavaType(this.modelProperties.getOriginalType());
        if (interfaze != null) {
            interfaze.addImportedType(modelType);
        }
        if (topLevelClass != null) {
            topLevelClass.addImportedType(modelType);
        }
        return true;
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientInsertSelectiveMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectAllMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean clientSelectAllMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return this.renameMethod(method);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.modelProperties.isEnabled()) {
            topLevelClass.setAbstract(true);
        }
        return true;
    }

    @ConstructorProperties(value={"modelProperties", "mapperProperties", "exampleProperties"})
    public CreateSubPackagePlugin(RenameProperties modelProperties, RenameProperties mapperProperties, RenameProperties exampleProperties) {
        this.modelProperties = modelProperties;
        this.mapperProperties = mapperProperties;
        this.exampleProperties = exampleProperties;
    }
}

