/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.subpackage;

import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameProperties {
    private static final Logger log = LoggerFactory.getLogger(RenameProperties.class);
    private static final String DOT = ".";
    private boolean enabled;
    private String subPpackage;
    private String classSuffix;
    private String originalType;
    private String newType;

    public void validate(String theSubPpackage, String theClassSuffix) {
        boolean bl = this.enabled = theSubPpackage != null || theClassSuffix != null;
        if (this.enabled) {
            this.subPpackage = theSubPpackage == null ? "" : (!theSubPpackage.startsWith(DOT) ? DOT + theSubPpackage : theSubPpackage);
            this.classSuffix = theClassSuffix == null ? "" : theClassSuffix;
        }
    }

    public String setTypes(String theOriginalType) {
        if (this.enabled) {
            this.originalType = theOriginalType;
            int lastDot = this.originalType.lastIndexOf(DOT);
            this.newType = this.originalType.substring(0, lastDot) + this.subPpackage + this.originalType.substring(lastDot) + this.classSuffix;
            log.debug("replace type [{}][{}]", (Object)this.originalType, (Object)this.newType);
            return this.newType;
        }
        return theOriginalType;
    }

    public FullyQualifiedJavaType renameType(FullyQualifiedJavaType theJavaType) {
        if (theJavaType.getFullyQualifiedName().contains(this.newType)) {
            log.debug("set new return type: [{}][{}]", (Object)this.newType, (Object)this.originalType);
            return new FullyQualifiedJavaType(theJavaType.getFullyQualifiedName().replace(this.newType, this.originalType));
        }
        return theJavaType;
    }

    public Attribute renameAttribute(Attribute attribute) {
        if (this.newType.equals(attribute.getValue())) {
            log.debug("set new model attribute: [{}][{}][{}]", new Object[]{attribute.getName(), this.newType, this.originalType});
            return new Attribute(attribute.getName(), this.originalType);
        }
        return attribute;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    String getSubPpackage() {
        return this.subPpackage;
    }

    String getClassSuffix() {
        return this.classSuffix;
    }

    String getOriginalType() {
        return this.originalType;
    }

    String getNewType() {
        return this.newType;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setSubPpackage(String subPpackage) {
        this.subPpackage = subPpackage;
    }

    void setClassSuffix(String classSuffix) {
        this.classSuffix = classSuffix;
    }

    void setOriginalType(String originalType) {
        this.originalType = originalType;
    }

    void setNewType(String newType) {
        this.newType = newType;
    }
}

