/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcendents.mybatis.generator.plugin.wrap;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class WrapObjectPlugin
extends PluginAdapter {
    public static final String TABLE_NAME = "fullyQualifiedTableName";
    public static final String OBJECT_CLASS = "objectClass";
    public static final String OBJECT_FIELD_NAME = "objectFieldName";
    public static final String INCLUDES = "includes";
    public static final String EXCLUDES = "excludes";
    private String tableName;
    private Class<?> objectClass;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private String objectFieldName;
    private Set<String> gettersToWrap = new HashSet<String>();
    private Set<String> settersToWrap = new HashSet<String>();

    public boolean validate(List<String> warnings) {
        String excludesString;
        this.tableName = this.properties.getProperty(TABLE_NAME);
        String objectClassName = this.properties.getProperty(OBJECT_CLASS);
        String warning = "Property %s not set for plugin %s";
        if (!StringUtility.stringHasValue((String)this.tableName)) {
            warnings.add(String.format(warning, TABLE_NAME, ((Object)((Object)this)).getClass().getSimpleName()));
        }
        if (!StringUtility.stringHasValue((String)objectClassName)) {
            warnings.add(String.format(warning, OBJECT_CLASS, ((Object)((Object)this)).getClass().getSimpleName()));
        } else {
            try {
                this.objectClass = Class.forName(objectClassName);
            }
            catch (ClassNotFoundException ex) {
                warnings.add(String.format("Could not load class %s in plugin %s", objectClassName, ((Object)((Object)this)).getClass().getSimpleName()));
            }
        }
        String includesString = this.properties.getProperty(INCLUDES);
        if (StringUtility.stringHasValue((String)includesString)) {
            for (String include : includesString.split(",")) {
                this.includes.add(include.trim());
            }
        }
        if (StringUtility.stringHasValue((String)(excludesString = this.properties.getProperty(EXCLUDES)))) {
            for (String exclude : excludesString.split(",")) {
                this.excludes.add(exclude.trim());
            }
        }
        this.objectFieldName = this.properties.getProperty(OBJECT_FIELD_NAME);
        if (!StringUtility.stringHasValue((String)this.objectFieldName) && this.objectClass != null) {
            this.objectFieldName = StringUtils.uncapitalize((String)this.objectClass.getSimpleName());
        }
        return StringUtility.stringHasValue((String)this.tableName) && this.objectClass != null;
    }

    private boolean tableMatches(IntrospectedTable introspectedTable) {
        return this.tableName.equals(introspectedTable.getFullyQualifiedTableNameAtRuntime());
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.tableMatches(introspectedTable)) {
            FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.objectClass.getName());
            Field field = new Field(this.objectFieldName, type);
            field.setVisibility(JavaVisibility.PROTECTED);
            field.setInitializationString(String.format("new %s()", this.objectClass.getSimpleName()));
            field.addJavaDocLine("/**");
            field.addJavaDocLine(" * This field was generated by MyBatis Generator.");
            field.addJavaDocLine(" * This field corresponds to the wrapped object.");
            field.addJavaDocLine(" *");
            field.addJavaDocLine(" * @mbggenerated");
            field.addJavaDocLine(" */");
            topLevelClass.addField(field);
            topLevelClass.addImportedType(type);
        }
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        if (this.tableMatches(introspectedTable) && this.wrapField(field)) {
            topLevelClass.addImportedType(field.getType());
            return false;
        }
        return true;
    }

    private boolean wrapField(Field field) {
        if (this.includes.contains(field.getName()) || this.includes.isEmpty() && !this.excludes.contains(field.getName())) {
            return this.objectClassHasFieldGetter(field);
        }
        return false;
    }

    private boolean objectClassHasFieldGetter(Field field) {
        java.lang.reflect.Method getter = null;
        FullyQualifiedJavaType type = field.getType();
        String prefix = type.isPrimitive() && type.getShortName().equals("boolean") ? "is" : "get";
        String capitalized = StringUtils.capitalize((String)field.getName());
        String getterName = prefix + capitalized;
        String setterName = "set" + capitalized;
        try {
            getter = this.objectClass.getDeclaredMethod(getterName, new Class[0]);
            this.gettersToWrap.add(getterName);
            this.settersToWrap.add(setterName);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        return getter != null;
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        if (this.tableMatches(introspectedTable) && this.gettersToWrap.contains(method.getName())) {
            method.getBodyLines().clear();
            method.addBodyLine(String.format("return this.%s.%s();", this.objectFieldName, method.getName()));
        }
        return true;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        if (this.tableMatches(introspectedTable) && this.settersToWrap.contains(method.getName())) {
            method.getBodyLines().clear();
            method.addBodyLine(String.format("this.%s.%s(%s);", this.objectFieldName, method.getName(), ((Parameter)method.getParameters().get(0)).getName()));
        }
        return true;
    }

    Set<String> getIncludes() {
        return this.includes;
    }

    Set<String> getExcludes() {
        return this.excludes;
    }

    String getObjectFieldName() {
        return this.objectFieldName;
    }

    Set<String> getGettersToWrap() {
        return this.gettersToWrap;
    }

    Set<String> getSettersToWrap() {
        return this.settersToWrap;
    }
}

