/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoServerMonitor;
import com.sap.conn.jco.rt.AbstractServerManager;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.JCoMiddleware;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerRunnable;
import com.sap.conn.jco.server.JCoServerThreadStarter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerManager
extends AbstractServerManager {
    private static final JCoServerThreadStarter defaultThreadStarter = new DefaultRunnableStarter();
    private static final int LISTENING_TIMEOUT = 2000;
    static final int FREE_LISTENER = -1;
    static final int STOP_WORKER_THREAD = -3;
    private static DefaultServerManager manager = new DefaultServerManager();
    JCoMiddleware.Dispatcher middlewareDispatcher = null;
    private DispatcherWorker dispatcherWorker = null;
    private ServerController serverController = null;
    private ServerFactory serverFactory = null;
    private JCoServerThreadStarter runnableStarter = defaultThreadStarter;
    private Object monitor = new Object();
    static final Hashtable<String, DefaultServer> runningServers = new Hashtable();

    DefaultServerManager() {
        this.middlewareDispatcher = JCoRuntimeFactory.getRuntime().getMiddlewareInstance().getDispatcherInterface();
        this.dispatcherWorker = new DispatcherWorker();
        this.serverController = new ServerController();
        this.serverFactory = new DefaultServerFactory();
    }

    private DefaultServerManager(ServerFactory serverFactory, JCoServerThreadStarter runnableStarter) {
        this.serverFactory = serverFactory == null ? DefaultServerManager.manager.serverFactory : serverFactory;
        this.runnableStarter = runnableStarter == null ? defaultThreadStarter : runnableStarter;
    }

    public static DefaultServerManager createCustomServerManager(ServerFactory serverFactory, JCoServerThreadStarter runnableStarter) {
        return new DefaultServerManager(serverFactory, runnableStarter);
    }

    static String computeGroupKey(Properties serverProperties) {
        return new StringBuilder(100).append(serverProperties.getProperty("jco.server.gwhost")).append("|").append(serverProperties.getProperty("jco.server.gwserv")).append("|").append(serverProperties.getProperty("jco.server.progid")).toString();
    }

    public final JCoServer getServer(Properties serverProperties) throws JCoException {
        return this.getServer(serverProperties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final DefaultServer getServer(Properties serverProperties, boolean create) throws JCoException {
        DefaultServer group;
        String key = DefaultServerManager.computeGroupKey(serverProperties);
        Hashtable<String, DefaultServer> hashtable = runningServers;
        synchronized (hashtable) {
            group = runningServers.get(key);
            if (group == null) {
                if (!create) {
                    throw new JCoRuntimeException(106, "JCO_ERROR_RESOURCE", "server group does not exist [key=" + key + "]");
                }
                group = this.serverFactory.createServer(serverProperties);
                if (group == null) {
                    throw new JCoRuntimeException(120, "JCO_ERROR_EXTENSION", this.serverFactory.getClass().getName() + ".createServer() returns null");
                }
                group.setServerKey(key);
                group.setServerThreadStarter(this.runnableStarter);
            }
        }
        return group;
    }

    final boolean isAvailable(String serverKey) {
        return runningServers.containsKey(serverKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addServer(DefaultServer server) {
        Object object = runningServers;
        synchronized (object) {
            if (runningServers.get(server.getServerKey()) == null) {
                runningServers.put(server.getServerKey(), server);
            }
        }
        if (!DefaultServerManager.manager.dispatcherWorker.isRunning()) {
            object = DefaultServerManager.manager.dispatcherWorker;
            synchronized (object) {
                if (!DefaultServerManager.manager.dispatcherWorker.isRunning()) {
                    Thread dispatcherThread = new Thread(JCoRuntime.jcoThreadGroup, DefaultServerManager.manager.dispatcherWorker, "JCoDispatcherWorkerThread");
                    dispatcherThread.setDaemon(true);
                    dispatcherThread.setPriority(10);
                    DefaultServerManager.manager.dispatcherWorker.setRunning();
                    dispatcherThread.start();
                }
            }
        }
        if (!DefaultServerManager.manager.serverController.isRunning()) {
            object = DefaultServerManager.manager.serverController;
            synchronized (object) {
                if (!DefaultServerManager.manager.serverController.isRunning()) {
                    Thread controllerThread = new Thread(JCoRuntime.jcoThreadGroup, DefaultServerManager.manager.serverController, "JCoServerControllerThread");
                    controllerThread.setDaemon(true);
                    DefaultServerManager.manager.serverController.setRunning();
                    controllerThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void releaseServer(JCoServer server) {
        try {
            DefaultServer s = (DefaultServer)server;
            Hashtable<String, DefaultServer> hashtable = runningServers;
            synchronized (hashtable) {
                s.destroy();
                runningServers.remove(s.getServerKey());
            }
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Illegal argument in JCoServerFactory.releaseServer() got " + server.getClass().getName() + ". Allowed are only instances created by JCoServerFactory");
        }
    }

    public final int getNumServerConnections(Properties serverProperties) throws JCoException {
        return this.middlewareDispatcher.getNumServerConnections(serverProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        ArrayList<DefaultServer> servers = new ArrayList<DefaultServer>();
        Hashtable<String, DefaultServer> hashtable = runningServers;
        synchronized (hashtable) {
            servers.addAll(runningServers.values());
        }
        for (DefaultServer server : servers) {
            server.getMonitoredData(monitoredData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<String> getServerIDs() {
        Hashtable<String, DefaultServer> hashtable = runningServers;
        synchronized (hashtable) {
            return new ArrayList<String>(runningServers.keySet());
        }
    }

    final JCoServerMonitor getServerMonitor(String serverID) {
        DefaultServer srv = runningServers.get(serverID);
        if (srv != null) {
            return srv.getMonitor();
        }
        throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Server with the ID " + serverID + " is not available.");
    }

    private static class DefaultRunnableStarter
    implements JCoServerThreadStarter {
        private static AtomicInteger threadNumber = new AtomicInteger(0);

        private DefaultRunnableStarter() {
        }

        public void start(JCoServerRunnable starter) throws Exception {
            Thread thread = new Thread(JCoRuntime.jcoThreadGroup, starter, "JCoServerThread-" + threadNumber.incrementAndGet());
            thread.setDaemon(false);
            thread.start();
        }
    }

    private class DefaultServerFactory
    implements ServerFactory {
        private DefaultServerFactory() {
        }

        public DefaultServer createServer(Properties serverProperties) throws JCoException {
            return new DefaultServer(serverProperties);
        }
    }

    private class ServerController
    implements Runnable {
        static final byte STOPPED = 0;
        static final byte RUNNING = 1;
        static final byte STOPPING = 2;
        private byte state = 0;

        private ServerController() {
        }

        void stop() {
            this.state = (byte)(this.state & 2);
        }

        void setRunning() {
            this.state = 1;
        }

        boolean isRunning() {
            return (this.state & 1) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while ((this.state & 2) == 0) {
                try {
                    DefaultServer[] servers;
                    Hashtable<String, DefaultServer> hashtable = runningServers;
                    synchronized (hashtable) {
                        servers = runningServers.values().toArray(new DefaultServer[runningServers.size()]);
                    }
                    for (int i = 0; i < servers.length; ++i) {
                        servers[i].adjustConnectionCount();
                    }
                    Object i = DefaultServerManager.this.monitor;
                    synchronized (i) {
                        DefaultServerManager.this.monitor.wait();
                    }
                }
                catch (Throwable t) {
                    try {
                        Trace.fireTraceCritical("[JCoAPI] caught Throwable in ServerController.run()", t);
                    }
                    catch (Throwable throwable) {}
                }
            }
            this.state = 0;
        }
    }

    private class DispatcherWorker
    implements Runnable {
        static final byte STOPPED = 0;
        static final byte RUNNING = 1;
        static final byte STOPPING = 2;
        private byte state = 0;

        private DispatcherWorker() {
        }

        void stop() {
            this.state = (byte)(this.state & 2);
        }

        void setRunning() {
            this.state = 1;
        }

        boolean isRunning() {
            return (this.state & 1) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int rc = 0;
            boolean traceGetNextHandle = false;
            ServerConnection serverConnection = null;
            int loopCount = 0;
            while ((this.state & 2) == 0) {
                try {
                    DefaultServer[] servers;
                    rc = DefaultServerManager.this.middlewareDispatcher.waitForRequest(2000);
                    if (Trace.isOn(32)) {
                        if (rc == 1) {
                            Trace.fireTrace(32, new StringBuilder(60).append("[JCoAPI] Dispatcher.waitForRequest(").append(2000).append(") = RC_DISPATCH_CALL").toString());
                            loopCount = 0;
                        } else if (loopCount == 0) {
                            Trace.fireTrace(32, new StringBuilder(60).append("[JCoAPI] Dispatcher.waitForRequest(").append(2000).append(") = RC_RETRY_LISTEN").toString());
                        }
                        loopCount = (short)(loopCount + 1);
                        if (loopCount >= 150) {
                            loopCount = 0;
                        }
                    }
                    traceGetNextHandle = Trace.isOn(128);
                    while (rc == 1) {
                        serverConnection = DefaultServerManager.this.middlewareDispatcher.getNextListener();
                        try {
                            if (traceGetNextHandle) {
                                if (serverConnection != null) {
                                    Trace.fireTrace(128, new StringBuilder(150).append("[JCoAPI] Dispatcher.getNextListener() = handle [").append(serverConnection.getConnectionHandle()).append("] for server ").append(serverConnection.serverGroup.getServerName()).append(" [").append(serverConnection.serverGroup.getServerKey()).append(']').toString());
                                } else {
                                    Trace.fireTrace(128, "[JCoAPI] Dispatcher.getNextListener() = null");
                                }
                            }
                            if (serverConnection != null) {
                                DefaultServer server = runningServers.get(serverConnection.serverGroup.getServerKey());
                                if (server != null) {
                                    server.dispatch(serverConnection);
                                    continue;
                                }
                                Trace.fireTraceCritical(new StringBuilder(180).append("[JCoAPI] Incoming call on handle [").append(serverConnection.getConnectionHandle()).append("] cannot be dispatched because the targeted server ").append(serverConnection.serverGroup.getServerName()).append(" [").append(serverConnection.serverGroup.getServerKey()).append("] was not found").toString());
                                continue;
                            }
                            rc = 0;
                        }
                        catch (Throwable t) {
                            Trace.fireTraceCritical("[JCoAPI] caught Throwable in DispatcherWorker.run() while trying to dispatch a request", t);
                        }
                    }
                    Hashtable<String, DefaultServer> hashtable = runningServers;
                    synchronized (hashtable) {
                        servers = runningServers.values().toArray(new DefaultServer[runningServers.size()]);
                    }
                    for (int i = 0; i < servers.length; ++i) {
                        servers[i].processQueuedRequests();
                    }
                    Object i = DefaultServerManager.this.monitor;
                    synchronized (i) {
                        DefaultServerManager.this.monitor.notifyAll();
                    }
                }
                catch (Throwable t) {
                    try {
                        Trace.fireTraceCritical("[JCoAPI] caught Throwable in DispatcherWorker.run()", t);
                    }
                    catch (Throwable tsec) {}
                }
            }
            this.state = 0;
        }
    }
}

