/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoResponse;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.CallbackHandler;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.rt.DefaultResponse;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.ServerAuthorizationData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoApplicationAuthorizationException;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerCallType;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandler;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import com.sap.conn.jco.server.JCoServerRunnable;
import com.sap.conn.jco.server.JCoServerSecurityHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.sap.conn.jco.server.JCoServerUnitIDHandler;

public class DefaultServerWorker
extends ServerWorker
implements JCoServerRunnable {
    private static ThreadLocal<DefaultServerWorker> localWorker = new ThreadLocal();
    private static DenyTxHandler denyTxHandler = new DenyTxHandler();
    private CallbackHandler callbackHandler = new CallbackHandlerImpl();
    protected JCoServerSecurityHandler securityHandler;
    protected JCoServerTIDHandler tidManager = denyTxHandler;
    protected JCoServerUnitIDHandler unitIDHandler = denyTxHandler;
    protected JCoServerCallHandlerFactory callHandlerFactory;
    protected ServerContext ctx = new ServerContext();
    protected CallDispatcher callDispatcher;
    volatile boolean stopping = false;
    volatile Thread workerThread = null;
    private volatile SessionReferenceProvider sessionRefProvider = null;

    protected DefaultServerWorker(DefaultServer defaultServer) {
        JCoServerUnitIDHandler serverUnitIDHandler;
        this.server = defaultServer;
        this.securityHandler = this.server.getSecurityHandler();
        this.callHandlerFactory = this.server.getCallHandlerFactory();
        if (this.callHandlerFactory instanceof JCoServerFunctionHandlerFactory) {
            this.callDispatcher = new FunctionDispatcher((JCoServerFunctionHandlerFactory)this.callHandlerFactory);
        } else if (this.callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
            this.callDispatcher = new RequestDispatcher((JCoServerRequestHandlerFactory)this.callHandlerFactory);
        }
        JCoServerTIDHandler serverTIDHandler = this.server.getTIDHandler();
        if (serverTIDHandler != null) {
            this.tidManager = serverTIDHandler;
        }
        if ((serverUnitIDHandler = this.server.getUnitIDHandler()) != null) {
            this.unitIDHandler = serverUnitIDHandler;
        }
    }

    protected static DefaultServerWorker getThreadLocalServerWorker() {
        return localWorker.get();
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public JCoServerContext getContext() throws IllegalStateException {
        ServerConnection serverConn = this.getConnection();
        if (serverConn == null || !serverConn.isValid()) {
            throw new IllegalStateException("Connection was not assigned or was already removed");
        }
        return this.ctx;
    }

    protected void fireServerErrorOccurred(Error error) {
        this.server.fireServerErrorOccurred(this, this.conn, error);
    }

    protected void fireServerExceptionOccurred(Exception exception) {
        this.server.fireServerExceptionOccurred(this, this.conn, exception);
    }

    protected boolean checkAuthorization(String functionName, ServerAuthorizationData authData) {
        if (this.securityHandler != null) {
            try {
                this.securityHandler.checkAuthorization(this.ctx, functionName, authData);
            }
            catch (JCoApplicationAuthorizationException ae) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTraceCritical("[JCoAPI] The application declines the authorization:", ae);
                }
                return false;
            }
            catch (Throwable th) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTraceCritical("[JCoAPI] The security handler threw an error at checking an authorization request:", th);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchRequest(JCoFunction function) throws AbapException, AbapClassException {
        try {
            localWorker.set(this);
            this.callDispatcher.handleRequest(this.ctx, function);
            Object var3_2 = null;
            localWorker.set(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            localWorker.set(null);
            throw throwable;
        }
    }

    protected JCoFunction getFunction(String functionName) throws JCoException {
        try {
            return this.callDispatcher.getFunction(this.ctx, functionName);
        }
        catch (RuntimeException ex) {
            this.fireServerExceptionOccurred(ex);
            throw ex;
        }
    }

    JCoRepository getRepository() {
        return this.server.getRepository(this.ctx);
    }

    void destroy() {
        this.workerThread = null;
        this.conn = null;
        this.server = null;
    }

    public Thread getThread() {
        return this.workerThread;
    }

    protected boolean onCheckTID(String tid) {
        this.ctx.tid = tid;
        return this.tidManager.checkTID(this.ctx, tid);
    }

    protected void onCommit(String tid) {
        this.ctx.tid = tid;
        this.tidManager.commit(this.ctx, tid);
    }

    protected void onConfirmTID(String tid) {
        this.tidManager.confirmTID(this.ctx, tid);
    }

    protected void onRollback(String tid) {
        this.ctx.tid = null;
        this.tidManager.rollback(this.ctx, tid);
    }

    public void run() {
        this.workerThread = Thread.currentThread();
        this.loop();
        if (Trace.isOn(16)) {
            Trace.fireTrace(16, new StringBuilder(85).append("[JCoAPI] Leaving method ServerWorker.run() in thread ").append(Thread.currentThread().getName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void dispatch() {
        block32: {
            if (Trace.isOn(32)) {
                Trace.fireTrace(32, new StringBuilder(100).append("[JCoAPI] ServerWorker.dispatch() in thread ").append(this.getThread().getName()).append(" on handle [").append(this.conn != null ? Long.valueOf(this.conn.getConnectionHandle()) : "null").append(']').toString());
            }
            if (this.conn == null && Trace.isOn(4, true)) {
                Trace.fireTrace(4, "ERROR: Connection is null in ServerWorker.dispatch()", true);
            }
            String lastErrorMsg = null;
            try {
                this.conn.middlewareServer.listen(this);
                Object var8_2 = null;
            }
            catch (Throwable throwable) {
                block33: {
                    Object var8_6 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (!Trace.isOn(4, true)) break block33;
                            Trace.fireTrace(4, new StringBuilder(200).append("[JCoAPI] Error occurred while aborting server connection with error message \"").append(lastErrorMsg).append("\": ").append(t.toString()).toString());
                        }
                    }
                }
                throw throwable;
            }
            if (lastErrorMsg != null && this.conn.isValid()) {
                this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                try {
                    this.abort(lastErrorMsg);
                }
                catch (Throwable t) {
                    if (Trace.isOn(4, true)) {
                        Trace.fireTrace(4, new StringBuilder(200).append("[JCoAPI] Error occurred while aborting server connection with error message \"").append(lastErrorMsg).append("\": ").append(t.toString()).toString());
                    }
                }
            }
            break block32;
            {
                catch (JCoException ex) {
                    String shortKey;
                    this.fireServerExceptionOccurred(ex);
                    switch (ex.getGroup()) {
                        case 104: {
                            shortKey = "";
                            break;
                        }
                        case 113: {
                            DefaultServer.RequestQueue requestQueue = this.server.getRequestQueue();
                            synchronized (requestQueue) {
                                JCoServerState state = this.server.getState();
                                if (state != JCoServerState.STOPPING && state != JCoServerState.STOPPED) {
                                    this.server.stop();
                                }
                            }
                            shortKey = "";
                            break;
                        }
                        case 102: {
                            shortKey = "COMMUNICATION_FAILURE ";
                            break;
                        }
                        default: {
                            shortKey = ex.getKey() + ": ";
                        }
                    }
                    lastErrorMsg = shortKey + ex.getMessage();
                    Object var8_3 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn(4, true)) {
                                Trace.fireTrace(4, new StringBuilder(200).append("[JCoAPI] Error occurred while aborting server connection with error message \"").append(lastErrorMsg).append("\": ").append(t.toString()).toString());
                            }
                        }
                    }
                    break block32;
                }
                catch (Exception ex) {
                    this.fireServerExceptionOccurred(ex);
                    lastErrorMsg = ex.toString();
                    Object var8_4 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn(4, true)) {
                                Trace.fireTrace(4, new StringBuilder(200).append("[JCoAPI] Error occurred while aborting server connection with error message \"").append(lastErrorMsg).append("\": ").append(t.toString()).toString());
                            }
                        }
                    }
                    break block32;
                }
                catch (Error err) {
                    this.fireServerErrorOccurred(err);
                    lastErrorMsg = err.toString();
                    Object var8_5 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn(4, true)) {
                                Trace.fireTrace(4, new StringBuilder(200).append("[JCoAPI] Error occurred while aborting server connection with error message \"").append(lastErrorMsg).append("\": ").append(t.toString()).toString());
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loop() {
        while (!this.stopping) {
            Object var6_4;
            DefaultServer.RequestQueue requestQueue = this.server.getRequestQueue();
            synchronized (requestQueue) {
                this.conn = this.server.getRequestQueue().getRequest();
            }
            try {
                if (this.conn != null) {
                    Object var4_3;
                    try {
                        try {
                            this.dispatch();
                        }
                        catch (Throwable t) {
                            Trace.fireTraceCritical("[JCoAPI] ServerWorker.dispatch() threw an exception:", t);
                            var4_3 = null;
                            this.server.getRequestQueue().requestFinished();
                        }
                        var4_3 = null;
                        this.server.getRequestQueue().requestFinished();
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        this.server.getRequestQueue().requestFinished();
                        throw throwable;
                    }
                }
                var6_4 = null;
                if (this.server == null) continue;
                this.server.releaseListener(this);
            }
            catch (Throwable throwable) {
                var6_4 = null;
                if (this.server != null) {
                    this.server.releaseListener(this);
                }
                throw throwable;
            }
        }
        this.server.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void abort(String message) throws JCoException {
        if (Trace.isOn(4, true)) {
            Trace.fireTrace(4, new StringBuilder(128).append("[JCoAPI] ServerWorker.abort(\"").append(message).append("\") on handle [").append(this.conn != null ? Long.valueOf(this.conn.getConnectionHandle()) : "null").append(']').toString());
        }
        try {
            if (this.isValid()) {
                this.conn.middlewareServer.abort(this, message);
            }
            Object var3_2 = null;
            this.setState((byte)(this.conn.state & 0xFFFFFFF7));
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setState((byte)(this.conn.state & 0xFFFFFFF7));
            throw throwable;
        }
    }

    void removeConnectionHandle() {
        this.conn.serverGroup.removeConnection(this.conn);
    }

    final String callStartedInternal() {
        String currentSessionID = null;
        this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, new StringBuilder(160).append("[JCoAPI] ServerWorker.callStartedInternal() uses SessionReferenceProvider: ").append(this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()).toString());
        }
        if (this.sessionRefProvider != null) {
            try {
                currentSessionID = this.conn.getSessionId();
                if (currentSessionID == null) {
                    JCoSessionReference ref = this.sessionRefProvider.jcoServerSessionStarted();
                    currentSessionID = ref != null ? ref.getID() : this.conn.getConversationID();
                } else {
                    this.sessionRefProvider.jcoServerSessionContinued(currentSessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(currentSessionID == null ? "jcoServerSessionStarted()" : "jcoServerSessionContinued()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(currentSessionID == null ? "jcoServerSessionStarted()" : "jcoServerSessionContinued()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            this.server.increaseRequestsInProcess();
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JCoAPI] ServerWorker.callStartedInternal() returns session ID " + currentSessionID);
        }
        return currentSessionID;
    }

    final void callFinishedInternal(String currentSessionID) {
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, new StringBuilder(160).append("[JCoAPI] ServerWorker.callFinishedInternal() uses cached SessionReferenceProvider: ").append(this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()).toString());
        }
        this.server.decreaseRequestsInProcess();
        if (this.sessionRefProvider != null) {
            String sessionID = this.conn.getSessionId();
            try {
                if (sessionID == null) {
                    this.sessionRefProvider.jcoServerSessionFinished(currentSessionID);
                } else {
                    this.sessionRefProvider.jcoServerSessionPassivated(sessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(sessionID == null ? "jcoServerSessionFinished()" : "jcoServerSessionPassivated()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, new StringBuilder(85).append("[JCoAPI] SessionReferenceProvider.").append(sessionID == null ? "jcoServerSessionFinished()" : "jcoServerSessionPassivated()").append(" threw an exception:").toString(), e);
                }
                throw e;
            }
            this.sessionRefProvider = null;
        }
    }

    protected void onSessionClose(String message, boolean error) {
        String sessionID;
        block16: {
            block15: {
                sessionID = this.conn.getSessionId();
                if (sessionID != null) {
                    if (this.sessionRefProvider == null) {
                        this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
                    }
                    if (this.sessionRefProvider != null) {
                        try {
                            this.sessionRefProvider.jcoServerSessionContinued(sessionID);
                        }
                        catch (Throwable th) {
                            if (!Trace.isOn(4)) break block15;
                            Trace.fireTrace(4, "[JCoAPI] SessionReferenceProvider.jcoServerSessionContinued() threw an exception:", th);
                        }
                    }
                }
            }
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, "[JCoAPI] ServerWorker.onSessionClose(): session is closed");
            }
            try {
                this.callHandlerFactory.sessionClosed(this.ctx, message, error);
            }
            catch (Throwable th) {
                if (!Trace.isOn(4)) break block16;
                Trace.fireTrace(4, "[JCoAPI] sessionClosed() in ServerWorker.onSessionClose() threw an exception:", th);
            }
        }
        if (sessionID != null) {
            block17: {
                Context context = DefaultServer.jcoRuntime.getRuntimeContext(sessionID, false);
                if (context != null) {
                    try {
                        context.setServerConnection(null);
                        DefaultServer.jcoRuntime.releaseRuntimeContext(context);
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4)) break block17;
                        Trace.fireTrace(4, "[JCoAPI] releaseRuntimeContext() in ServerWorker.onSessionClose() threw an exception:", th);
                    }
                }
            }
            if (this.sessionRefProvider != null) {
                block18: {
                    try {
                        this.sessionRefProvider.jcoServerSessionFinished(sessionID);
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4)) break block18;
                        Trace.fireTrace(4, "[JCoAPI] SessionReferenceProvider.jcoServerSessionFinished() threw an exception:", th);
                    }
                }
                this.sessionRefProvider = null;
            }
        }
    }

    void setState(byte state) {
        this.conn.state = state;
    }

    byte getState() {
        return this.conn.state;
    }

    private static class DenyTxHandler
    implements JCoServerTIDHandler,
    JCoServerUnitIDHandler {
        private DenyTxHandler() {
        }

        public boolean checkUnitID(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public void commit(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public void confirmUnitID(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public JCoFunctionUnitState getFunctionUnitState(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public void rollback(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        public void commit(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        public void confirmTID(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        public void rollback(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }
    }

    public class RequestDispatcher
    extends CallDispatcher {
        private JCoServerRequestHandlerFactory aFactory;

        public RequestDispatcher(JCoServerRequestHandlerFactory factory) {
            this.aFactory = factory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected JCoServerRequestHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            JCoServerRequestHandler handler;
            block13: {
                block12: {
                    handler = null;
                    String errorMsg = null;
                    if (Trace.isOn(64)) {
                        Trace.fireTrace(64, new StringBuilder(125).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before getCallHandler()").toString());
                    }
                    try {
                        try {
                            handler = this.aFactory.getCallHandler(serverCtx, function.getName());
                        }
                        catch (RuntimeException re) {
                            errorMsg = re.toString();
                            throw re;
                        }
                        catch (Error er) {
                            errorMsg = er.toString();
                            throw er;
                        }
                        Object var7_5 = null;
                        if (errorMsg == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (errorMsg != null) {
                            Trace.fireTrace(4, new StringBuilder(160).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] getCallHandler() fails with: ").append(errorMsg).toString());
                            throw throwable;
                        }
                        if (!Trace.isOn(64)) throw throwable;
                        Trace.fireTrace(64, new StringBuilder(200).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                        throw throwable;
                    }
                    Trace.fireTrace(4, new StringBuilder(160).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] getCallHandler() fails with: ").append(errorMsg).toString());
                    break block13;
                }
                if (Trace.isOn(64)) {
                    Trace.fireTrace(64, new StringBuilder(200).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                }
            }
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuilder(180).append("The JCoServerRequestHandlerFactory ").append(this.aFactory.getClass().getName()).append(" returns null for function name ").append(function.getName()).toString());
            }
            if (Trace.isOn(64)) {
                StringBuilder buf = new StringBuilder(125).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before handleRequest()");
                if (Trace.isOn(16)) {
                    Trace.dumpFunction(buf, Trace.isOn(256), true, false, function);
                }
                Trace.fireTrace(64, buf.toString());
            }
            DefaultRequest request = new DefaultRequest(function);
            DefaultResponse response = request.getResponse();
            handler.handleRequest(serverCtx, request, response);
            if (!Trace.isOn(64)) return handler;
            StringBuilder buf = new StringBuilder(150).append("[JCoAPI] RequestDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after handleRequest() returns after ").append(System.currentTimeMillis() - DefaultServerWorker.this.conn.start_time).append(" ms");
            if (Trace.isOn(16)) {
                Trace.dumpFunction(buf, false, false, true, function);
            }
            Trace.fireTrace(64, buf.toString());
            return handler;
        }
    }

    public class FunctionDispatcher
    extends CallDispatcher {
        private JCoServerFunctionHandlerFactory aFactory;

        public FunctionDispatcher(JCoServerFunctionHandlerFactory factory) {
            this.aFactory = factory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected JCoServerFunctionHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            StringBuilder buf;
            JCoServerFunctionHandler handler;
            block13: {
                block12: {
                    handler = null;
                    String errorMsg = null;
                    if (Trace.isOn(64)) {
                        Trace.fireTrace(64, new StringBuilder(125).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before getCallHandler()").toString());
                    }
                    try {
                        try {
                            handler = this.aFactory.getCallHandler(serverCtx, function.getName());
                        }
                        catch (RuntimeException re) {
                            errorMsg = re.toString();
                            throw re;
                        }
                        catch (Error er) {
                            errorMsg = er.toString();
                            throw er;
                        }
                        Object var7_5 = null;
                        if (errorMsg == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (errorMsg != null) {
                            Trace.fireTrace(4, new StringBuilder(160).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] getCallHandler() fails with: ").append(errorMsg).toString());
                            throw throwable;
                        }
                        if (!Trace.isOn(64)) throw throwable;
                        Trace.fireTrace(64, new StringBuilder(200).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                        throw throwable;
                    }
                    Trace.fireTrace(4, new StringBuilder(160).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] getCallHandler() fails with: ").append(errorMsg).toString());
                    break block13;
                }
                if (Trace.isOn(64)) {
                    Trace.fireTrace(64, new StringBuilder(200).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after getCallHandler() returns ").append(handler != null ? handler.getClass().getName() : "null").toString());
                }
            }
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuilder(180).append("The JCoServerFunctionHandlerFactory ").append(this.aFactory.getClass().getName()).append(" returns null for function name ").append(function.getName()).toString());
            }
            if (Trace.isOn(64)) {
                buf = new StringBuilder(125).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] before handleRequest()");
                if (Trace.isOn(16)) {
                    Trace.dumpFunction(buf, Trace.isOn(256), true, false, function);
                }
                Trace.fireTrace(64, buf.toString());
            }
            handler.handleRequest(serverCtx, function);
            if (!Trace.isOn(64)) return handler;
            buf = new StringBuilder(150).append("[JCoAPI] FunctionDispatcher.handleRequest(").append(function.getName()).append(") on handle [").append(DefaultServerWorker.this.getConnectionHandle()).append("] after handleRequest() returns after ").append(System.currentTimeMillis() - DefaultServerWorker.this.conn.start_time).append(" ms");
            if (Trace.isOn(16)) {
                Trace.dumpFunction(buf, false, false, true, function);
            }
            Trace.fireTrace(64, buf.toString());
            return handler;
        }
    }

    public abstract class CallDispatcher {
        protected CallDispatcher() {
        }

        protected CallDispatcher(JCoServerCallHandlerFactory factory) {
        }

        protected abstract Object handleRequest(JCoServerContext var1, JCoFunction var2) throws AbapException, AbapClassException;

        protected JCoFunction getFunction(JCoServerContext serverCtx, String functionName) throws JCoException {
            return DefaultServerWorker.this.server.getRepository(serverCtx).getFunction(functionName);
        }
    }

    final class BgRfcCallContext {
        AbapFunctionUnit.UnitIdentifier unitIdentifier = new AbapFunctionUnit.UnitIdentifier();
        JCoBackgroundUnitAttributes unitAttributes = null;

        BgRfcCallContext() {
        }
    }

    class ServerContext
    implements JCoServerContext {
        JCoServerCallType callType = JCoServerCallType.SYNCHRONOUS;
        BgRfcCallContext bgRfcCallCtx = new BgRfcCallContext();
        String tid;

        ServerContext() {
        }

        public JCoAttributes getConnectionAttributes() {
            try {
                return DefaultServerWorker.this.conn.getAttributes();
            }
            catch (JCoException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] ServerConnection.getAttributes() threw an exception:", e);
                }
                return null;
            }
        }

        public String getConnectionID() {
            return DefaultServerWorker.this.conn.getConnectionId();
        }

        public JCoRepository getRepository() {
            return DefaultServerWorker.this.server.getRepository(this);
        }

        public JCoServer getServer() {
            return DefaultServerWorker.this.server;
        }

        public String getSessionID() {
            return DefaultServerWorker.this.conn.getSessionId();
        }

        public String getTID() {
            return this.tid;
        }

        public boolean isInTransaction() {
            return this.tid != null || this.bgRfcCallCtx.unitIdentifier.getType() != null;
        }

        public JCoServerCallType getCallType() {
            return this.callType;
        }

        public JCoUnitIdentifier getUnitIdentifier() {
            if (this.bgRfcCallCtx.unitIdentifier.getType() != null) {
                return this.bgRfcCallCtx.unitIdentifier;
            }
            return null;
        }

        public JCoBackgroundUnitAttributes getFunctionUnitAttributes() {
            if (this.getCallType() == JCoServerCallType.BACKGROUND_UNIT) {
                return this.bgRfcCallCtx.unitAttributes;
            }
            return null;
        }

        public boolean isStatefulSession() {
            return this.getSessionID() != null;
        }

        public void setStateful(boolean stateful) {
            if (Trace.isOn(128)) {
                Trace.fireTrace(128, new StringBuilder(42).append("[JCoAPI] ServerContext.setStateful(").append(stateful).append(')').toString());
            }
            String connectionSessionId = DefaultServerWorker.this.conn.getSessionId();
            if (stateful && connectionSessionId == null) {
                String sessionID = null;
                JCoSessionReference sesRef = null;
                SessionReferenceProvider sesRefProvider = DefaultServerWorker.this.sessionRefProvider;
                if (sesRefProvider == null) {
                    sesRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
                }
                if (sesRefProvider != null) {
                    if (Trace.isOn(128)) {
                        Trace.fireTrace(128, new StringBuilder(120).append("[JCoAPI] Use ").append(sesRefProvider == DefaultServerWorker.this.sessionRefProvider ? "central" : "cached").append(" SessionReferenceProvider: ").append(sesRefProvider.getClass().getName()).toString());
                    }
                    try {
                        sesRef = sesRefProvider.getCurrentSessionReference(null);
                        if (sesRef == null) {
                            Trace.fireTraceCritical("[JCoAPI] SessionReferenceProvider.getCurrentSessionReference(null) returned null");
                        } else {
                            sessionID = sesRef.getID();
                        }
                    }
                    catch (Exception e) {
                        Trace.fireTraceCritical(new StringBuilder(85).append("[JCoAPI] ").append(sesRef == null ? "SessionReferenceProvider.getCurrentSessionReference(null)" : "JCoSessionReference().getID()").append(" threw an exception:").toString(), e);
                    }
                }
                if (sessionID == null) {
                    Trace.fireTraceCritical("[JCoAPI] The current session ID is null and the conversation ID will be used instead");
                    sessionID = DefaultServerWorker.this.conn.getConversationID();
                }
                DefaultServerWorker.this.conn.setSessionState(true, sessionID);
                Context context = DefaultServer.jcoRuntime.getRuntimeContext(sessionID, true);
                context.setServerConnection(DefaultServerWorker.this.conn);
                if (sesRef != null) {
                    context.setSessionReference(sesRef, null);
                }
            } else if (!stateful && connectionSessionId != null) {
                Context context = DefaultServer.jcoRuntime.getRuntimeContext(connectionSessionId, false);
                if (context != null) {
                    context.setServerConnection(null);
                }
                DefaultServerWorker.this.conn.setSessionState(false, connectionSessionId);
            }
        }
    }

    protected class CallbackHandlerImpl
    implements CallbackHandler {
        protected CallbackHandlerImpl() {
        }

        void checkState() {
            if ((DefaultServerWorker.this.conn.state & 4) == 0) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "CallbackHandler can only be used during request handling");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(JCoFunction function) throws JCoException {
            int i3;
            boolean isTaskMonitorOn;
            DefaultParameterList outputTables;
            DefaultParameterList inputTables;
            DefaultParameterList output;
            DefaultParameterList changing;
            block43: {
                int i3222;
                int i2;
                int i22;
                this.checkState();
                long start_time_callback = System.currentTimeMillis();
                String name = function.getName();
                DefaultParameterList input = (DefaultParameterList)function.getImportParameterList();
                changing = (DefaultParameterList)function.getChangingParameterList();
                output = (DefaultParameterList)function.getExportParameterList();
                inputTables = (DefaultParameterList)function.getTableParameterList();
                outputTables = (DefaultParameterList)function.getTableParameterList();
                isTaskMonitorOn = DefaultServer.jcoRuntime.isTaskMonitorOn();
                if (isTaskMonitorOn) {
                    DefaultServer.jcoRuntime.startTask(new StringBuilder(100).append("JCo executing ").append(name).append(" [").append(DefaultServerWorker.this.conn.attributes.sysid).append('|').append(DefaultServerWorker.this.conn.attributes.getPartnerHost()).append('|').append(DefaultServerWorker.this.conn.getConversationID()).append(']').toString());
                }
                if (input != null) {
                    input.checkIfInitialized();
                    for (i22 = 0; i22 < input.getMetaData().getFieldCount(); ++i22) {
                        if (input.isActive(i22) && input.isInitialized(i22)) continue;
                        int n = i22;
                        input.flags[n] = (byte)(input.flags[n] | 8);
                    }
                }
                if (inputTables != null) {
                    for (i22 = 0; i22 < inputTables.getMetaData().getFieldCount(); ++i22) {
                        if (inputTables.isActive(i22)) continue;
                        int n = i22;
                        inputTables.flags[n] = (byte)(inputTables.flags[n] | 8);
                    }
                }
                if (changing != null) {
                    changing.checkIfInitialized();
                    for (i2 = 0; i2 < changing.getMetaData().getFieldCount(); ++i2) {
                        if (changing.isActive(i2) && changing.isInitialized(i2)) continue;
                        int n = i2;
                        changing.flags[n] = (byte)(changing.flags[n] | 8);
                    }
                }
                if (output != null) {
                    for (int i23 = 0; i23 < output.getMetaData().getFieldCount(); ++i23) {
                        if (output.isActive(i23)) continue;
                        int n = i23;
                        output.flags[n] = (byte)(output.flags[n] | 8);
                    }
                }
                if (outputTables != null) {
                    for (i2 = 0; i2 < outputTables.getMetaData().getFieldCount(); ++i2) {
                        if (outputTables.isActive(i2)) continue;
                        int n = i2;
                        outputTables.flags[n] = (byte)(outputTables.flags[n] | 8);
                    }
                }
                try {
                    try {
                        if (Trace.isOn(64)) {
                            StringBuilder buf = new StringBuilder(120).append("[JCoAPI] ServerWorker.execute(").append(name).append(") on handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("]");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, Trace.isOn(256), true, false, function);
                            }
                            Trace.fireTrace(64, buf.toString());
                        }
                        DefaultServerWorker.this.conn.middlewareServer.execute(DefaultServerWorker.this, name, input, inputTables, changing, output, ((AbapFunction)function).supportsASXML(), ((AbapFunction)function).getAbapClassExceptionMode());
                        if (Trace.isOn(64)) {
                            StringBuilder buf = new StringBuilder(200).append("[JCoAPI] ServerWorker.execute(").append(name).append(") on handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("] returns after ").append(System.currentTimeMillis() - start_time_callback).append(" ms");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, false, false, true, function);
                            }
                            Trace.fireTrace(64, buf.toString());
                        }
                    }
                    catch (AbapException ex) {
                        if (!Trace.isOn(64)) throw ex;
                        Trace.fireTrace(64, new StringBuilder(120).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw an ABAP exception: ").append(ex.toString()).toString());
                        throw ex;
                    }
                    catch (JCoException ex) {
                        if (Trace.isOn(32)) {
                            Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw a non-ABAP exception:").toString(), ex);
                            throw ex;
                        }
                        if (!Trace.isOn(4)) throw ex;
                        Trace.fireTrace(4, new StringBuilder(120).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw a non-ABAP exception: ").append(ex.toString()).toString());
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (Trace.isOn(32)) {
                            Trace.fireTrace(4, new StringBuilder(100).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw a non-ABAP exception:").toString(), ex);
                            throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                        }
                        if (!Trace.isOn(4)) throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                        Trace.fireTrace(4, new StringBuilder(120).append("[JCoAPI] ServerWorker.execute(").append(name).append(") threw a non-ABAP exception: ").append(ex.toString()).toString());
                        throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                    }
                    Object var13_16 = null;
                    if (input == null) break block43;
                    i3222 = 0;
                }
                catch (Throwable throwable) {
                    int i3;
                    Object var13_17 = null;
                    if (input != null) {
                        int i3222 = 0;
                        while (i3222 < input.getMetaData().getFieldCount()) {
                            int n = i3222++;
                            input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (inputTables != null) {
                        int i4 = 0;
                        while (i4 < inputTables.getMetaData().getFieldCount()) {
                            int n = i4++;
                            inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (changing != null) {
                        int i32 = 0;
                        while (i32 < changing.getMetaData().getFieldCount()) {
                            int n = i32++;
                            changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (output != null) {
                        i3 = 0;
                        while (i3 < output.getMetaData().getFieldCount()) {
                            int n = i3++;
                            output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (outputTables != null) {
                        i3 = 0;
                        while (i3 < outputTables.getMetaData().getFieldCount()) {
                            int n = i3++;
                            outputTables.flags[n] = (byte)(outputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (!isTaskMonitorOn) throw throwable;
                    DefaultServer.jcoRuntime.endTask();
                    throw throwable;
                }
                while (i3222 < input.getMetaData().getFieldCount()) {
                    int n = i3222++;
                    input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                }
            }
            if (inputTables != null) {
                int i4 = 0;
                while (i4 < inputTables.getMetaData().getFieldCount()) {
                    int n = i4++;
                    inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (changing != null) {
                int i32 = 0;
                while (i32 < changing.getMetaData().getFieldCount()) {
                    int n = i32++;
                    changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                }
            }
            if (output != null) {
                i3 = 0;
                while (i3 < output.getMetaData().getFieldCount()) {
                    int n = i3++;
                    output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                }
            }
            if (outputTables != null) {
                i3 = 0;
                while (i3 < outputTables.getMetaData().getFieldCount()) {
                    int n = i3++;
                    outputTables.flags[n] = (byte)(outputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (!isTaskMonitorOn) return;
            DefaultServer.jcoRuntime.endTask();
        }

        public JCoResponse execute(JCoRequest request) throws JCoException {
            if (request == null) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "JCoRequest is null");
            }
            try {
                this.execute(((DefaultRequest)request).function);
                return ((DefaultRequest)request).getResponse();
            }
            catch (ClassCastException e) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unexpected JCoRequest type " + request.getClass().getName() + " detected");
            }
        }

        public JCoFunction getFunction(String functionName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getFunction(functionName);
        }

        public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getStructureDefinition(structureName);
        }
    }
}

