/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.json.CacheIterator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RecordCacheIterator
extends CacheIterator<DefaultRecordMetaData> {
    private List<String> processed = new ArrayList<String>(100);

    RecordCacheIterator(BasicRepository r, String[] names) {
        super(r, names);
    }

    @Override
    public boolean hasNext() {
        while (this.i < this.names.length) {
            String name = this.names[this.i];
            DefaultRecordMetaData md = this.rep.getRecordMetaDataFromCache(name);
            if (md == null) {
                throw new JCoRuntimeException(190, "Unable to resolve " + name);
            }
            if (this.checkNested(md)) {
                return true;
            }
            ++this.i;
        }
        this.next = null;
        return false;
    }

    private boolean checkNested(DefaultRecordMetaData md) {
        for (int i = 0; i < md.getFieldCount(); ++i) {
            String nestedMdName;
            if (!md.isTable(i) && !md.isStructure(i) || !this.checkNested(this.rep.getRecordMetaDataFromCache(nestedMdName = md.getRecordTypeName(i)))) continue;
            return true;
        }
        if (this.isWanted(md)) {
            this.next = md;
            return true;
        }
        return false;
    }

    boolean isProcessed(String name) {
        return this.processed.contains(name);
    }

    void markAsProcessed(String name) {
        this.processed.add(name);
    }

    abstract boolean isWanted(DefaultRecordMetaData var1);
}

