/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.CustomRepository;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.rt.json.JCoRepositorySerializationException;
import com.sap.conn.jco.rt.json.JSonClassMetaDataReader;
import com.sap.conn.jco.rt.json.JSonFunctionTemplateReader;
import com.sap.conn.jco.rt.json.JSonParser;
import com.sap.conn.jco.rt.json.JSonStructureReader;
import com.sap.conn.jco.rt.json.JSonTableReader;
import java.io.IOException;
import java.io.Reader;

public class RepReader {
    private BasicRepository r;

    public RepReader(JCoRepository r) {
        this.r = (BasicRepository)r;
    }

    public void load(String source) throws IOException {
        this.load(new JSonParser(source));
    }

    public void load(Reader reader) throws IOException {
        this.load(new JSonParser(reader));
    }

    void load(JSonParser parser) throws IOException {
        int ch;
        boolean isVersionOk = false;
        parser.assertChar('{');
        boolean first = true;
        while ((ch = parser.nextNonBlankChar()) != -1) {
            if (ch == 125) {
                if (isVersionOk) {
                    return;
                }
                throw new JCoRepositorySerializationException("missing attribute format");
            }
            if (first) {
                first = false;
                parser.undo();
            } else if (ch != 44) {
                throw new JCoRepositorySerializationException("missing ',' ", parser);
            }
            String attribute = parser.nextString();
            if ("name".equals(attribute)) {
                parser.assertChar(':');
                parser.nextString();
                continue;
            }
            if ("unicodeEnabled".equals(attribute)) {
                parser.assertChar(':');
                boolean isUc = parser.nextBool();
                if (!(this.r instanceof CustomRepository)) continue;
                ((CustomRepository)this.r).setContainsUnicodeInfo(isUc);
                continue;
            }
            if ("structures".equals(attribute)) {
                parser.assertChar(':');
                new JSonStructureReader(parser).read(this.r);
                continue;
            }
            if ("tables".equals(attribute)) {
                parser.assertChar(':');
                new JSonTableReader(parser).read(this.r);
                continue;
            }
            if ("functions".equals(attribute)) {
                parser.assertChar(':');
                new JSonFunctionTemplateReader(parser).read(this.r);
                continue;
            }
            if ("classes".equals(attribute)) {
                parser.assertChar(':');
                new JSonClassMetaDataReader(parser).read(this.r);
                continue;
            }
            if ("format".equals(attribute)) {
                parser.assertChar(':');
                String version = parser.nextString();
                isVersionOk = version.startsWith("1.");
                if (isVersionOk) continue;
                throw new JCoRuntimeException(191, "Unable to read serialization format " + version + ". The only supported format by this implemantation is 1.x");
            }
            if (Trace.isOn(8, true)) {
                Trace.fireTrace(8, "unknown repository attribute \"" + attribute + "\"");
            }
            throw new JCoRuntimeException(191, "unknown repository attribute " + attribute);
        }
        throw new JCoRuntimeException(191, "unexpected end of stream (repository incomplete)");
    }
}

