/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class BinaryCodec
implements UuidCodec<byte[]> {
    public static final BinaryCodec INSTANCE = new BinaryCodec();

    @Override
    public byte[] encode(UUID uuid) {
        UuidValidator.validate(uuid);
        byte[] bytes = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        bytes[0] = (byte)(msb >>> 56);
        bytes[1] = (byte)(msb >>> 48);
        bytes[2] = (byte)(msb >>> 40);
        bytes[3] = (byte)(msb >>> 32);
        bytes[4] = (byte)(msb >>> 24);
        bytes[5] = (byte)(msb >>> 16);
        bytes[6] = (byte)(msb >>> 8);
        bytes[7] = (byte)msb;
        bytes[8] = (byte)(lsb >>> 56);
        bytes[9] = (byte)(lsb >>> 48);
        bytes[10] = (byte)(lsb >>> 40);
        bytes[11] = (byte)(lsb >>> 32);
        bytes[12] = (byte)(lsb >>> 24);
        bytes[13] = (byte)(lsb >>> 16);
        bytes[14] = (byte)(lsb >>> 8);
        bytes[15] = (byte)lsb;
        return bytes;
    }

    @Override
    public UUID decode(byte[] bytes) {
        UuidValidator.validate(bytes);
        long msb = 0L;
        long lsb = 0L;
        msb |= ((long)bytes[0] & 0xFFL) << 56;
        msb |= ((long)bytes[1] & 0xFFL) << 48;
        msb |= ((long)bytes[2] & 0xFFL) << 40;
        msb |= ((long)bytes[3] & 0xFFL) << 32;
        msb |= ((long)bytes[4] & 0xFFL) << 24;
        msb |= ((long)bytes[5] & 0xFFL) << 16;
        msb |= ((long)bytes[6] & 0xFFL) << 8;
        msb |= (long)bytes[7] & 0xFFL;
        lsb |= ((long)bytes[8] & 0xFFL) << 56;
        lsb |= ((long)bytes[9] & 0xFFL) << 48;
        lsb |= ((long)bytes[10] & 0xFFL) << 40;
        lsb |= ((long)bytes[11] & 0xFFL) << 32;
        lsb |= ((long)bytes[12] & 0xFFL) << 24;
        lsb |= ((long)bytes[13] & 0xFFL) << 16;
        lsb |= ((long)bytes[14] & 0xFFL) << 8;
        return new UUID(msb, lsb |= (long)bytes[15] & 0xFFL);
    }
}

