/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.NoArgsFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;

public abstract class AbstRandomBasedFactory
extends UuidFactory
implements NoArgsFactory {
    protected final IRandom random;
    protected static final int UUID_BYTES = 16;

    protected AbstRandomBasedFactory(UuidVersion version, Builder<?, ?> builder) {
        super(version);
        this.random = builder.getRandom();
    }

    protected static final class ByteRandom
    implements IRandom {
        private final IntFunction<byte[]> randomFunction;

        public ByteRandom() {
            this(ByteRandom.newRandomFunction(null));
        }

        public ByteRandom(Random random) {
            this(ByteRandom.newRandomFunction(random));
        }

        public ByteRandom(IntFunction<byte[]> randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : ByteRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            byte[] bytes = this.randomFunction.apply(8);
            return ByteUtil.toNumber(bytes);
        }

        @Override
        public byte[] nextBytes(int length) {
            return this.randomFunction.apply(length);
        }

        protected static IntFunction<byte[]> newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
    }

    protected static final class LongRandom
    implements IRandom {
        private final LongSupplier randomFunction;

        public LongRandom() {
            this(LongRandom.newRandomFunction(null));
        }

        public LongRandom(Random random) {
            this(LongRandom.newRandomFunction(random));
        }

        public LongRandom(LongSupplier randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : LongRandom.newRandomFunction(null);
        }

        @Override
        public long nextLong() {
            return this.randomFunction.getAsLong();
        }

        @Override
        public byte[] nextBytes(int length) {
            int shift = 0;
            long random = 0L;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (shift < 8) {
                    shift = 64;
                    random = this.randomFunction.getAsLong();
                }
                bytes[i] = (byte)(random >>> (shift -= 8));
            }
            return bytes;
        }

        protected static LongSupplier newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return entropy::nextLong;
        }
    }

    protected static interface IRandom {
        public long nextLong();

        public byte[] nextBytes(int var1);
    }

    protected static abstract class Builder<T, B extends Builder<T, B>> {
        protected IRandom random;

        protected Builder() {
        }

        protected IRandom getRandom() {
            if (this.random == null) {
                this.random = new ByteRandom(new DefaultRandomFunction());
            }
            return this.random;
        }

        public B withRandom(Random random) {
            if (random != null) {
                this.random = random instanceof SecureRandom ? new ByteRandom(random) : new LongRandom(random);
            }
            return (B)this;
        }

        public B withFastRandom() {
            this.random = new LongRandom(() -> ThreadLocalRandom.current().nextLong());
            return (B)this;
        }

        public B withRandomFunction(LongSupplier randomFunction) {
            this.random = new LongRandom(randomFunction);
            return (B)this;
        }

        public B withRandomFunction(IntFunction<byte[]> randomFunction) {
            this.random = new ByteRandom(randomFunction);
            return (B)this;
        }

        public abstract T build();
    }
}

