/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import java.util.UUID;

public abstract class UuidFactory {
    protected final UuidVersion version;
    protected final long versionMask;

    public UuidFactory(UuidVersion version) {
        this.version = version;
        this.versionMask = (long)version.getValue() << 12;
    }

    public UuidVersion getVersion() {
        return this.version;
    }

    protected UUID toUuid(long msb, long lsb) {
        long msb0 = msb & 0xFFFFFFFFFFFF0FFFL | this.versionMask;
        long lsb0 = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb0, lsb0);
    }
}

