/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util.internal;

import com.github.f4b6a3.uuid.util.internal.SettingsUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class RandomUtil {
    protected static final SecureRandom SHARED_RANDOM = RandomUtil.newSecureRandom();

    private RandomUtil() {
    }

    public static int nextInt() {
        return SHARED_RANDOM.nextInt();
    }

    public static long nextLong() {
        return SHARED_RANDOM.nextLong();
    }

    public static SecureRandom newSecureRandom() {
        String algorithm = SettingsUtil.getSecureRandom();
        if (algorithm != null) {
            try {
                return SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                return new SecureRandom();
            }
        }
        return new SecureRandom();
    }
}

