/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql;

import com.github.jasync.sql.db.ConcreteConnectionBase;
import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.ResultSet;
import com.github.jasync.sql.db.ResultSetKt;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.exceptions.ConnectionStillRunningQueryException;
import com.github.jasync.sql.db.exceptions.DatabaseException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.interceptor.PreparedStatementParams;
import com.github.jasync.sql.db.mysql.MySQLConnection;
import com.github.jasync.sql.db.mysql.MySQLConnectionKt;
import com.github.jasync.sql.db.mysql.MySQLQueryResult;
import com.github.jasync.sql.db.mysql.codec.MySQLConnectionHandler;
import com.github.jasync.sql.db.mysql.codec.MySQLHandlerDelegate;
import com.github.jasync.sql.db.mysql.exceptions.MySQLException;
import com.github.jasync.sql.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.jasync.sql.db.mysql.message.client.CapabilityRequestMessage;
import com.github.jasync.sql.db.mysql.message.client.HandshakeResponseMessage;
import com.github.jasync.sql.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.jasync.sql.db.mysql.message.server.EOFMessage;
import com.github.jasync.sql.db.mysql.message.server.ErrorMessage;
import com.github.jasync.sql.db.mysql.message.server.HandshakeMessage;
import com.github.jasync.sql.db.mysql.message.server.OkMessage;
import com.github.jasync.sql.db.mysql.util.CapabilityFlag;
import com.github.jasync.sql.db.mysql.util.CharsetMapper;
import com.github.jasync.sql.db.pool.TimeoutScheduler;
import com.github.jasync.sql.db.pool.TimeoutSchedulerImpl;
import com.github.jasync.sql.db.util.ChannelFutureTransformerKt;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.NettyUtils;
import com.github.jasync.sql.db.util.Success;
import com.github.jasync.sql.db.util.Try;
import com.github.jasync.sql.db.util.VersionKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 `2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002`aB>\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012#\b\u0002\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0017H\u0002J\u0014\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00190'H\u0002J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\u0010\u0010\u0011\u001a\u0002012\u0006\u00106\u001a\u000207H\u0016J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J\u0010\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020\"H\u0016J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020\"H\u0002J\b\u0010=\u001a\u00020\u0010H\u0016J\u0006\u0010>\u001a\u00020\u0010J\b\u0010?\u001a\u00020\u0010H\u0016J\b\u0010@\u001a\u00020\u0010H\u0016J\b\u0010A\u001a\u00020\u0010H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010B\u001a\u000201H\u0002J\u0010\u0010C\u001a\u0002012\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u0002012\u0006\u0010D\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u0002012\u0006\u0010D\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u0002012\u0006\u0010D\u001a\u00020KH\u0016J\b\u0010L\u001a\u000201H\u0002J\u0018\u0010M\u001a\u0002012\u0006\u0010N\u001a\u00020$2\u0006\u0010D\u001a\u00020EH\u0016J\u0014\u0010O\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00190'H\u0002J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u00102\u001a\u00020\u0017H\u0016J\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020(0\u00192\u0006\u0010R\u001a\u00020SH\u0016J\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020(0\u00192\u0006\u00102\u001a\u00020\u0017H\u0016J\u0010\u0010U\u001a\u0002012\u0006\u0010<\u001a\u00020\"H\u0002J\u0016\u0010V\u001a\u0002012\f\u0010W\u001a\b\u0012\u0004\u0012\u00020(0\u0019H\u0002J\u0010\u0010X\u001a\u0002012\u0006\u0010Y\u001a\u00020(H\u0002J\u0010\u0010Z\u001a\u0002012\u0006\u0010D\u001a\u00020[H\u0016J\b\u0010\\\u001a\u00020\u0017H\u0016J\b\u0010]\u001a\u000201H\u0016J\b\u0010^\u001a\u000201H\u0002J\u000e\u0010_\u001a\n\u0018\u00010.j\u0004\u0018\u0001`/R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00190'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n\u0018\u00010.j\u0004\u0018\u0001`/X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/github/jasync/sql/db/mysql/MySQLConnection;", "Lcom/github/jasync/sql/db/ConcreteConnectionBase;", "Lcom/github/jasync/sql/db/mysql/codec/MySQLHandlerDelegate;", "Lcom/github/jasync/sql/db/Connection;", "Lcom/github/jasync/sql/db/pool/TimeoutScheduler;", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "charsetMapper", "Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "withDelegate", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "delegate", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;Lkotlin/jvm/functions/Function1;)V", "channelClosed", "", "connected", "connectionCount", "", "connectionHandler", "Lcom/github/jasync/sql/db/mysql/codec/MySQLConnectionHandler;", "connectionId", "", "connectionPromise", "Ljava/util/concurrent/CompletableFuture;", "createTimeoutSchedulerImpl", "Lcom/github/jasync/sql/db/pool/TimeoutSchedulerImpl;", "disconnectionPromise", "id", "getId", "()Ljava/lang/String;", "isStoredProcedureCall", "lastException", "", "lastResultSet", "Lcom/github/jasync/sql/db/ResultSet;", "queryPromiseReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/Optional;", "Lcom/github/jasync/sql/db/QueryResult;", "queryTimeoutSchedulerImpl", "reportErrorAfterChannelClosed", "serverStatus", "", "serverVersion", "Lkotlin/KotlinVersion;", "Lcom/github/jasync/sql/db/util/Version;", "checkStoredProcedureCall", "", "query", "clearQueryPromise", "close", "connect", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "disconnect", "exceptionCaught", "exception", "failQueryPromise", "t", "hasRecentError", "isAutoCommit", "isConnected", "isQuerying", "isTimeout", "onCreateTimeout", "onEOF", "message", "Lcom/github/jasync/sql/db/mysql/message/server/EOFMessage;", "onError", "Lcom/github/jasync/sql/db/mysql/message/server/ErrorMessage;", "onHandshake", "Lcom/github/jasync/sql/db/mysql/message/server/HandshakeMessage;", "onOk", "Lcom/github/jasync/sql/db/mysql/message/server/OkMessage;", "onQueryTimeout", "onResultSet", "resultSet", "queryPromise", "releasePreparedStatement", "sendPreparedStatementDirect", "params", "Lcom/github/jasync/sql/db/interceptor/PreparedStatementParams;", "sendQueryDirect", "setException", "setQueryPromise", "promise", "succeedQueryPromise", "queryResult", "switchAuthentication", "Lcom/github/jasync/sql/db/mysql/message/server/AuthenticationSwitchRequest;", "toString", "unregistered", "validateIsReadyForQuery", "version", "Companion", "StatusFlags", "jasync-mysql"})
public final class MySQLConnection
extends ConcreteConnectionBase
implements MySQLHandlerDelegate,
Connection,
TimeoutScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long connectionCount;
    @NotNull
    private final String connectionId;
    @NotNull
    private final String id;
    @NotNull
    private final MySQLConnectionHandler connectionHandler;
    @NotNull
    private final CompletableFuture<MySQLConnection> connectionPromise;
    @NotNull
    private final CompletableFuture<Connection> disconnectionPromise;
    @NotNull
    private final AtomicReference<Optional<CompletableFuture<QueryResult>>> queryPromiseReference;
    private boolean isStoredProcedureCall;
    @NotNull
    private ResultSet lastResultSet;
    private boolean connected;
    @Nullable
    private Throwable lastException;
    @Nullable
    private KotlinVersion serverVersion;
    private int serverStatus;
    @NotNull
    private final TimeoutSchedulerImpl queryTimeoutSchedulerImpl;
    @NotNull
    private final TimeoutSchedulerImpl createTimeoutSchedulerImpl;
    private boolean channelClosed;
    private boolean reportErrorAfterChannelClosed;
    @NotNull
    private static final AtomicLong Counter = new AtomicLong();
    @NotNull
    private static final KotlinVersion MicrosecondsVersion = new KotlinVersion(5, 6, 0);
    @NotNull
    private static final Regex regexForCallInQueryStart = new Regex("\\s*call\\s+.*", RegexOption.IGNORE_CASE);
    @NotNull
    public static final String CLIENT_FOUND_ROWS_PROP_NAME = "jasync.mysql.CLIENT_FOUND_ROWS";

    @JvmOverloads
    public MySQLConnection(@NotNull Configuration configuration, @NotNull CharsetMapper charsetMapper, @NotNull Function1<? super MySQLHandlerDelegate, ? extends MySQLHandlerDelegate> withDelegate) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)charsetMapper, (String)"charsetMapper");
        Intrinsics.checkNotNullParameter(withDelegate, (String)"withDelegate");
        super(configuration);
        charsetMapper.toInt(configuration.getCharset());
        this.connectionCount = Counter.incrementAndGet();
        this.id = this.connectionId = "<mysql-connection-" + this.connectionCount + '>';
        this.connectionHandler = new MySQLConnectionHandler(configuration, charsetMapper, (MySQLHandlerDelegate)withDelegate.invoke((Object)this), configuration.getEventLoopGroup(), configuration.getExecutionContext(), this.connectionId);
        this.connectionPromise = new CompletableFuture();
        this.disconnectionPromise = new CompletableFuture();
        this.queryPromiseReference = new AtomicReference(Optional.empty());
        this.lastResultSet = ResultSetKt.getEMPTY_RESULT_SET();
        this.queryTimeoutSchedulerImpl = new TimeoutSchedulerImpl(configuration.getExecutionContext(), configuration.getEventLoopGroup(), (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                MySQLConnection.access$onQueryTimeout((MySQLConnection)this.receiver);
            }
        });
        this.createTimeoutSchedulerImpl = new TimeoutSchedulerImpl(configuration.getExecutionContext(), configuration.getEventLoopGroup(), (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                MySQLConnection.access$onCreateTimeout((MySQLConnection)this.receiver);
            }
        });
    }

    public /* synthetic */ MySQLConnection(Configuration configuration, CharsetMapper charsetMapper, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charsetMapper = CharsetMapper.Companion.getInstance();
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(configuration, charsetMapper, (Function1<? super MySQLHandlerDelegate, ? extends MySQLHandlerDelegate>)function1);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public final boolean isAutoCommit() {
        return (this.serverStatus & 2) != 0;
    }

    @Nullable
    public final KotlinVersion version() {
        return this.serverVersion;
    }

    @Nullable
    public Throwable lastException() {
        return this.lastException;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<MySQLConnection> connect() {
        void $this$onFailureAsync$iv;
        this.createTimeoutSchedulerImpl.addTimeout(this.connectionPromise, Duration.ofMillis(this.getConfiguration().getConnectionTimeout()), this.connectionId);
        CompletableFuture<MySQLConnectionHandler> completableFuture = this.connectionHandler.connect();
        Executor executor$iv = this.getConfiguration().getExecutionContext();
        boolean $i$f$onFailureAsync = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$onFailureAsync$iv.whenCompleteAsync(new BiConsumer(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = mySQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void accept(Object object, Throwable t) {
                if (t != null) {
                    Throwable e = t;
                    boolean bl = false;
                    FutureUtilsKt.failed((CompletableFuture)MySQLConnection.access$getConnectionPromise$p(this.this$0), (Throwable)e);
                }
            }
        }, executor$iv), (String)"crossinline onFailureFun\u2026ailureFun(t) }, executor)");
        return this.connectionPromise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Connection> close() {
        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "close connection " + MySQLConnection.access$getConnectionId$p(this.this$0);
            }
        });
        this.channelClosed = true;
        DatabaseException exception = new DatabaseException("Connection is being closed");
        this.failQueryPromise((Throwable)exception);
        if (this.isConnected() && !FutureUtilsKt.isCompleted(this.disconnectionPromise)) {
            void $this$onCompleteAsync$iv;
            MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
                final /* synthetic */ MySQLConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "send quit message " + MySQLConnection.access$getConnectionId$p(this.this$0);
                }
            });
            CompletableFuture<Channel> completableFuture = this.connectionHandler.sendQuitMessage();
            Executor executor$iv = this.getConfiguration().getExecutionContext();
            boolean $i$f$onCompleteAsync = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$onCompleteAsync$iv.whenCompleteAsync(new BiConsumer(this){
                final /* synthetic */ MySQLConnection this$0;
                {
                    this.this$0 = mySQLConnection;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final void accept(Object a, Throwable t) {
                    Throwable throwable = t;
                    Try ty1 = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                    boolean bl = false;
                    Try try_ = ty1;
                    if (try_ instanceof Success) {
                        void $this$onCompleteAsync$iv;
                        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this.this$0){
                            final /* synthetic */ MySQLConnection this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "close channel " + MySQLConnection.access$getConnectionId$p(this.this$0);
                            }
                        });
                        CompletableFuture completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)MySQLConnection.access$getConnectionHandler$p(this.this$0).closeChannel());
                        Executor executor$iv = this.this$0.getConfiguration().getExecutionContext();
                        boolean $i$f$onCompleteAsync = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$onCompleteAsync$iv.whenCompleteAsync(new BiConsumer(this.this$0){
                            final /* synthetic */ MySQLConnection this$0;
                            {
                                this.this$0 = mySQLConnection;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void accept(Object a, Throwable t) {
                                Throwable throwable = t;
                                Try ty2 = throwable != null ? Try.Companion.raise(throwable) : Try.Companion.just(a);
                                boolean bl = false;
                                MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this.this$0){
                                    final /* synthetic */ MySQLConnection this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @Nullable
                                    public final Object invoke() {
                                        return "channel was closed " + MySQLConnection.access$getConnectionId$p(this.this$0);
                                    }
                                });
                                Try try_ = ty2;
                                if (try_ instanceof Success) {
                                    MySQLConnection.access$getDisconnectionPromise$p(this.this$0).complete(this.this$0);
                                } else if (try_ instanceof Failure) {
                                    FutureUtilsKt.complete((CompletableFuture)MySQLConnection.access$getDisconnectionPromise$p(this.this$0), (Try)ty2);
                                }
                            }
                        }, executor$iv), (String)"crossinline onCompleteFu\u2026just(a))\n    }, executor)");
                    } else if (try_ instanceof Failure) {
                        MySQLConnection.access$getConnectionHandler$p(this.this$0).closeChannel();
                        FutureUtilsKt.complete((CompletableFuture)MySQLConnection.access$getDisconnectionPromise$p(this.this$0), (Try)ty1);
                    }
                }
            }, executor$iv), (String)"crossinline onCompleteFu\u2026just(a))\n    }, executor)");
        }
        return this.disconnectionPromise;
    }

    @Override
    public void unregistered() {
        MySQLConnectionKt.access$getLogger$p().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.this$0.isQuerying() ? this.this$0.getId() + " - client got disconnected in the middle of query execution" : this.this$0.getId() + " - client got disconnected with no running query";
            }
        });
        CompletableFuture<Connection> $this$mapTry$iv = this.close();
        boolean $i$f$mapTry = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$mapTry$iv.handle(new BiFunction(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = mySQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Object apply(Object a, @Nullable Throwable t) {
                void throwable;
                Throwable throwable2 = t;
                Connection cfr_ignored_0 = (Connection)a;
                boolean bl = false;
                if (throwable != null) {
                    MySQLConnectionKt.access$getLogger$p().warn((Throwable)throwable, (Function0)new Function0<Object>(this.this$0){
                        final /* synthetic */ MySQLConnection this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "failed to unregister " + MySQLConnection.access$getConnectionId$p(this.this$0);
                        }
                    });
                }
                return Unit.INSTANCE;
            }
        }), (String)"crossinline f: (A, Throw\u2026: Throwable? -> f(a, t) }");
    }

    public boolean isTimeout() {
        return this.queryTimeoutSchedulerImpl.isTimeout();
    }

    @Override
    public void connected(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        MySQLConnectionKt.access$getLogger$p().debug((Function0)new Function0<Object>(this, ctx){
            final /* synthetic */ MySQLConnection this$0;
            final /* synthetic */ ChannelHandlerContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " Connected to " + this.$ctx.channel().remoteAddress();
            }
        });
        this.connected = true;
    }

    @Override
    public void exceptionCaught(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (this.channelClosed) {
            MySQLConnectionKt.access$getLogger$p().trace(exception, (Function0)new Function0<Object>(this){
                final /* synthetic */ MySQLConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return MySQLConnection.access$getConnectionId$p(this.this$0) + " Transport failure after connection close";
                }
            });
            if (!this.reportErrorAfterChannelClosed) {
                MySQLConnectionKt.access$getLogger$p().info((Function0)new Function0<Object>(this, exception){
                    final /* synthetic */ MySQLConnection this$0;
                    final /* synthetic */ Throwable $exception;
                    {
                        this.this$0 = $receiver;
                        this.$exception = $exception;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return MySQLConnection.access$getConnectionId$p(this.this$0) + " Transport failure after connection close: " + this.$exception.getMessage();
                    }
                });
                this.reportErrorAfterChannelClosed = true;
            }
        }
        MySQLConnectionKt.access$getLogger$p().error(this.connectionId + " Transport failure ", exception);
        this.setException(exception);
    }

    @Override
    public void onError(@NotNull ErrorMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MySQLConnectionKt.access$getLogger$p().error(this.connectionId + " Received an error message -> {}", (Object)message);
        MySQLException exception = new MySQLException(message);
        this.setException((Throwable)((Object)exception));
    }

    private final void setException(Throwable t) {
        this.lastException = t;
        FutureUtilsKt.failed(this.connectionPromise, (Throwable)t);
        this.failQueryPromise(t);
    }

    @Override
    public void onOk(@NotNull OkMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.serverStatus = message.getStatusFlags();
        if (!FutureUtilsKt.isCompleted(this.connectionPromise)) {
            MySQLConnectionKt.access$getLogger$p().debug(this.connectionId + " Connected to database");
            FutureUtilsKt.success(this.connectionPromise, (Object)this);
        } else if (this.isQuerying()) {
            if (this.isStoredProcedureCall) {
                this.succeedQueryPromise(new MySQLQueryResult(message.getAffectedRows(), message.getMessage(), message.getLastInsertId(), message.getStatusFlags(), message.getWarnings(), this.lastResultSet));
            } else {
                this.succeedQueryPromise(new MySQLQueryResult(message.getAffectedRows(), message.getMessage(), message.getLastInsertId(), message.getStatusFlags(), message.getWarnings(), null, 32, null));
            }
        } else {
            MySQLConnectionKt.access$getLogger$p().warn(this.connectionId + " Received OK when not querying or connecting, not sure what this is: " + message);
        }
    }

    @Override
    public void onEOF(@NotNull EOFMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MySQLConnectionKt.access$getLogger$p().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ MySQLConnection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " onEOF isStoredProcedureCall=" + MySQLConnection.access$isStoredProcedureCall$p(this.this$0) + " isQuerying=" + this.this$0.isQuerying();
            }
        });
        this.serverStatus = message.getFlags();
        if (this.isQuerying() && !this.isStoredProcedureCall) {
            this.succeedQueryPromise(new MySQLQueryResult(0L, null, -1L, message.getFlags(), message.getWarningCount(), null, 32, null));
        }
    }

    @Override
    public void onHandshake(@NotNull HandshakeMessage message) {
        Object $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222;
        boolean clientFoundRows;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.serverVersion = VersionKt.parseVersion((String)message.getServerVersion());
        this.serverStatus = message.getStatusFlags();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfiguration().getSsl().getMode().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = message.supportsSSL();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (!message.supportsSSL()) {
                    boolean $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = false;
                    String $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = "SSL is not supported on server";
                    throw new IllegalArgumentException($i$a$-require-MySQLConnection$onHandshake$switchToSsl$222.toString());
                }
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean switchToSsl = bl;
        boolean bl2 = clientFoundRows = System.getProperty(CLIENT_FOUND_ROWS_PROP_NAME) != null;
        if (clientFoundRows) {
            MySQLConnectionKt.access$getLogger$p().debug((Function0)onHandshake.1.INSTANCE);
        }
        CapabilityFlag[] capabilityFlagArray = new CapabilityFlag[9];
        capabilityFlagArray[0] = CapabilityFlag.CLIENT_PLUGIN_AUTH;
        Object object = $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = CapabilityFlag.CLIENT_FOUND_ROWS;
        int n = 1;
        CapabilityFlag[] capabilityFlagArray2 = capabilityFlagArray;
        boolean bl3 = false;
        boolean bl4 = clientFoundRows;
        capabilityFlagArray2[n] = bl4 ? $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 : null;
        capabilityFlagArray[2] = CapabilityFlag.CLIENT_PROTOCOL_41;
        capabilityFlagArray[3] = CapabilityFlag.CLIENT_TRANSACTIONS;
        capabilityFlagArray[4] = CapabilityFlag.CLIENT_MULTI_RESULTS;
        capabilityFlagArray[5] = CapabilityFlag.CLIENT_SECURE_CONNECTION;
        CapabilityFlag it = $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = CapabilityFlag.CLIENT_SSL;
        n = 6;
        capabilityFlagArray2 = capabilityFlagArray;
        boolean bl5 = false;
        bl4 = switchToSsl;
        capabilityFlagArray2[n] = bl4 ? $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 : null;
        it = $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = CapabilityFlag.CLIENT_CONNECT_WITH_DB;
        n = 7;
        capabilityFlagArray2 = capabilityFlagArray;
        boolean bl6 = false;
        bl4 = this.getConfiguration().getDatabase() != null;
        capabilityFlagArray2[n] = bl4 ? $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 : null;
        it = $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = CapabilityFlag.CLIENT_CONNECT_ATTRS;
        n = 8;
        capabilityFlagArray2 = capabilityFlagArray;
        boolean bl7 = false;
        bl4 = this.getConfiguration().getApplicationName() != null;
        capabilityFlagArray2[n] = bl4 ? $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 : null;
        Set set = SetsKt.setOfNotNull((Object[])capabilityFlagArray);
        CapabilityRequestMessage capabilities = new CapabilityRequestMessage(set);
        $i$a$-require-MySQLConnection$onHandshake$switchToSsl$222 = this.getConfiguration().getUsername();
        object = this.getConfiguration().getCharset();
        byte[] byArray = message.getSeed();
        String string = message.getAuthenticationMethod();
        String string2 = this.getConfiguration().getDatabase();
        String string3 = this.getConfiguration().getPassword();
        String string4 = this.getConfiguration().getApplicationName();
        HandshakeResponseMessage handshakeResponse = new HandshakeResponseMessage(capabilities, (String)$i$a$-require-MySQLConnection$onHandshake$switchToSsl$222, (Charset)object, byArray, string, string3, string2, string4);
        if (!switchToSsl) {
            this.connectionHandler.write(handshakeResponse);
            return;
        }
        ChannelFuture channelFuture = this.connectionHandler.write(capabilities);
        channelFuture.addListener(arg_0 -> MySQLConnection.onHandshake$lambda-10(channelFuture, this, handshakeResponse, arg_0));
    }

    @Override
    public void switchAuthentication(@NotNull AuthenticationSwitchRequest message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.connectionHandler.write(new AuthenticationSwitchResponse(this.getConfiguration().getPassword(), message));
    }

    @NotNull
    public CompletableFuture<QueryResult> sendQueryDirect(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this, query){
            final /* synthetic */ MySQLConnection this$0;
            final /* synthetic */ String $query;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " sendQuery() - " + this.$query;
            }
        });
        this.validateIsReadyForQuery();
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        this.checkStoredProcedureCall(query);
        this.connectionHandler.sendQuery(query);
        this.queryTimeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        return promise;
    }

    private final void failQueryPromise(Throwable t) {
        this.clearQueryPromise().ifPresent(arg_0 -> MySQLConnection.failQueryPromise$lambda-11(t, arg_0));
    }

    private final void succeedQueryPromise(QueryResult queryResult) {
        this.clearQueryPromise().ifPresent(arg_0 -> MySQLConnection.succeedQueryPromise$lambda-12(queryResult, arg_0));
    }

    public boolean isQuerying() {
        return this.queryPromise().isPresent();
    }

    @Override
    public void onResultSet(@NotNull ResultSet resultSet, @NotNull EOFMessage message) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.isQuerying()) {
            if (this.isStoredProcedureCall) {
                this.lastResultSet = resultSet;
            } else {
                this.succeedQueryPromise(new MySQLQueryResult(resultSet.size(), null, -1L, message.getFlags(), message.getWarningCount(), resultSet));
            }
        } else {
            MySQLConnectionKt.access$getLogger$p().warn((Function0)new Function0<Object>(this){
                final /* synthetic */ MySQLConnection this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return MySQLConnection.access$getConnectionId$p(this.this$0) + " onResultSet - called without active query";
                }
            });
        }
    }

    @NotNull
    public CompletableFuture<Connection> disconnect() {
        return this.close();
    }

    private final void onQueryTimeout() {
        this.disconnect();
    }

    private final void onCreateTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler.isConnected();
    }

    public boolean hasRecentError() {
        return this.lastException != null;
    }

    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatementDirect(@NotNull PreparedStatementParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        MySQLConnectionKt.access$getLogger$p().trace((Function0)new Function0<Object>(this, params){
            final /* synthetic */ MySQLConnection this$0;
            final /* synthetic */ PreparedStatementParams $params;
            {
                this.this$0 = $receiver;
                this.$params = $params;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return MySQLConnection.access$getConnectionId$p(this.this$0) + " sendPreparedStatement() - " + this.$params;
            }
        });
        this.validateIsReadyForQuery();
        CharSequence $this$count$iv = params.getQuery();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '?')) continue;
            ++count$iv;
        }
        int totalParameters = count$iv;
        if (CollectionsUtilsKt.getLength((Collection)params.getValues()) != totalParameters) {
            throw new InsufficientParametersException(totalParameters, params.getValues());
        }
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        this.checkStoredProcedureCall(params.getQuery());
        this.connectionHandler.sendPreparedStatement(params.getQuery(), params.getValues());
        this.queryTimeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        CompletableFuture closedPromise = this.releaseIfNeeded(params.getRelease(), promise, params.getQuery());
        return closedPromise;
    }

    private final void checkStoredProcedureCall(String query) {
        CharSequence charSequence = query;
        if (regexForCallInQueryStart.matches(charSequence)) {
            this.isStoredProcedureCall = true;
        }
    }

    @NotNull
    public CompletableFuture<Boolean> releasePreparedStatement(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.validateIsReadyForQuery();
        return this.connectionHandler.closePreparedStatement(query);
    }

    @NotNull
    public String toString() {
        String string = "%s(%s,%d)";
        Object[] objectArray = new Object[]{this.getClass().getName(), this.connectionId, this.connectionCount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    private final void validateIsReadyForQuery() {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected so can't execute queries. please make sure connect() was called and disconnect() was not called.");
        }
        if (this.isQuerying()) {
            throw new ConnectionStillRunningQueryException(this.getId(), false);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> queryPromise() {
        Optional<CompletableFuture<QueryResult>> optional = this.queryPromiseReference.get();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"queryPromiseReference.get()");
        return optional;
    }

    private final void setQueryPromise(CompletableFuture<QueryResult> promise) {
        if (!this.queryPromiseReference.compareAndSet(Optional.empty(), Optional.of(promise))) {
            throw new ConnectionStillRunningQueryException(this.getId(), true);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> clearQueryPromise() {
        Optional<CompletableFuture<QueryResult>> currentPromise = this.queryPromiseReference.getAndSet(Optional.empty());
        if (currentPromise.isPresent()) {
            this.isStoredProcedureCall = false;
            this.lastResultSet = ResultSetKt.getEMPTY_RESULT_SET();
        }
        Intrinsics.checkNotNullExpressionValue(currentPromise, (String)"currentPromise");
        return currentPromise;
    }

    @JvmOverloads
    public MySQLConnection(@NotNull Configuration configuration, @NotNull CharsetMapper charsetMapper) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)charsetMapper, (String)"charsetMapper");
        this(configuration, charsetMapper, null, 4, null);
    }

    @JvmOverloads
    public MySQLConnection(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(configuration, null, null, 6, null);
    }

    private static final void onHandshake$lambda-10$lambda-9(MySQLConnection this$0, HandshakeResponseMessage $handshakeResponse, Future handshakeFuture) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$handshakeResponse, (String)"$handshakeResponse");
                if (!handshakeFuture.isSuccess()) break block0;
                this$0.connectionHandler.write($handshakeResponse);
                break block1;
            }
            MySQLConnectionKt.access$getLogger$p().error(handshakeFuture.cause(), (Function0)onHandshake.2.1.1.INSTANCE);
            Throwable throwable = handshakeFuture.cause();
            if (throwable == null) break block1;
            Throwable p0 = throwable;
            boolean bl = false;
            this$0.setException(p0);
        }
    }

    private static final void onHandshake$lambda-10(ChannelFuture $channelFuture, MySQLConnection this$0, HandshakeResponseMessage $handshakeResponse, Future sslRequestFuture) {
        ChannelHandler[] channelHandlerArray;
        Intrinsics.checkNotNullParameter((Object)$channelFuture, (String)"$channelFuture");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$handshakeResponse, (String)"$handshakeResponse");
        if (!sslRequestFuture.isSuccess()) {
            return;
        }
        Channel channel = $channelFuture.channel();
        try {
            SslContext sslContext = NettyUtils.INSTANCE.createSslContext(this$0.getConfiguration().getSsl());
            SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), this$0.getConfiguration().getHost(), this$0.getConfiguration().getPort());
            if (this$0.getConfiguration().getSsl().getMode() == SSLConfiguration.Mode.VerifyFull) {
                Intrinsics.checkNotNullExpressionValue((Object)sslEngine, (String)"sslEngine");
                NettyUtils.INSTANCE.verifyHostIdentity(sslEngine);
            }
            channelHandlerArray = new SslHandler(sslEngine);
        }
        catch (Exception e) {
            MySQLConnectionKt.access$getLogger$p().error((Throwable)e, (Function0)onHandshake.2.handler.1.INSTANCE);
            this$0.setException(e);
            return;
        }
        ChannelHandler[] handler2 = channelHandlerArray;
        channelHandlerArray = new ChannelHandler[]{(ChannelHandler)handler2};
        channel.pipeline().addFirst(channelHandlerArray);
        handler2.handshakeFuture().addListener(arg_0 -> MySQLConnection.onHandshake$lambda-10$lambda-9(this$0, $handshakeResponse, arg_0));
    }

    private static final void failQueryPromise$lambda-11(Throwable $t, CompletableFuture it) {
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FutureUtilsKt.failed((CompletableFuture)it, (Throwable)$t);
    }

    private static final void succeedQueryPromise$lambda-12(QueryResult $queryResult, CompletableFuture it) {
        Intrinsics.checkNotNullParameter((Object)$queryResult, (String)"$queryResult");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FutureUtilsKt.success((CompletableFuture)it, (Object)$queryResult);
    }

    public static final /* synthetic */ String access$getConnectionId$p(MySQLConnection $this) {
        return $this.connectionId;
    }

    public static final /* synthetic */ boolean access$isStoredProcedureCall$p(MySQLConnection $this) {
        return $this.isStoredProcedureCall;
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionPromise$p(MySQLConnection $this) {
        return $this.connectionPromise;
    }

    public static final /* synthetic */ CompletableFuture access$getDisconnectionPromise$p(MySQLConnection $this) {
        return $this.disconnectionPromise;
    }

    public static final /* synthetic */ MySQLConnectionHandler access$getConnectionHandler$p(MySQLConnection $this) {
        return $this.connectionHandler;
    }

    public static final /* synthetic */ void access$onQueryTimeout(MySQLConnection $this) {
        $this.onQueryTimeout();
    }

    public static final /* synthetic */ void access$onCreateTimeout(MySQLConnection $this) {
        $this.onCreateTimeout();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/jasync/sql/db/mysql/MySQLConnection$Companion;", "", "()V", "CLIENT_FOUND_ROWS_PROP_NAME", "", "Counter", "Ljava/util/concurrent/atomic/AtomicLong;", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "MicrosecondsVersion", "Lkotlin/KotlinVersion;", "Lcom/github/jasync/sql/db/util/Version;", "getMicrosecondsVersion$annotations", "getMicrosecondsVersion", "()Lkotlin/KotlinVersion;", "regexForCallInQueryStart", "Lkotlin/text/Regex;", "jasync-mysql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicLong getCounter() {
            return Counter;
        }

        @NotNull
        public final KotlinVersion getMicrosecondsVersion() {
            return MicrosecondsVersion;
        }

        public static /* synthetic */ void getMicrosecondsVersion$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/jasync/sql/db/mysql/MySQLConnection$StatusFlags;", "", "()V", "AUTO_COMMIT", "", "jasync-mysql"})
    public static final class StatusFlags {
        @NotNull
        public static final StatusFlags INSTANCE = new StatusFlags();
        public static final int AUTO_COMMIT = 2;

        private StatusFlags() {
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SSLConfiguration.Mode.values().length];
            nArray[SSLConfiguration.Mode.Disable.ordinal()] = 1;
            nArray[SSLConfiguration.Mode.Prefer.ordinal()] = 2;
            nArray[SSLConfiguration.Mode.Require.ordinal()] = 3;
            nArray[SSLConfiguration.Mode.VerifyCA.ordinal()] = 4;
            nArray[SSLConfiguration.Mode.VerifyFull.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

