/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.binary;

import com.github.jasync.sql.db.mysql.binary.encoder.BinaryEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.BooleanEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.ByteArrayEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.ByteBufEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.ByteBufferEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.ByteEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.CalendarEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.DateTimeEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.DoubleEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.DurationEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.FloatEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.IntegerEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.JavaDateEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.LocalDateEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.LocalDateTimeEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.LocalTimeEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.LongEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.ReadableInstantEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.SQLDateEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.SQLTimeEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.SQLTimestampEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.ShortEncoder;
import com.github.jasync.sql.db.mysql.binary.encoder.StringEncoder;
import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0001R\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/jasync/sql/db/mysql/binary/BinaryRowEncoder;", "", "charset", "Ljava/nio/charset/Charset;", "(Ljava/nio/charset/Charset;)V", "encoders", "", "Ljava/lang/Class;", "Lcom/github/jasync/sql/db/mysql/binary/encoder/BinaryEncoder;", "stringEncoder", "Lcom/github/jasync/sql/db/mysql/binary/encoder/StringEncoder;", "encoderFor", "v", "jasync-mysql"})
public final class BinaryRowEncoder {
    @NotNull
    private final StringEncoder stringEncoder;
    @NotNull
    private final Map<Class<?>, BinaryEncoder> encoders;

    public BinaryRowEncoder(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.stringEncoder = new StringEncoder(charset);
        Pair[] pairArray = new Pair[]{TuplesKt.to(String.class, (Object)this.stringEncoder), TuplesKt.to(BigInteger.class, (Object)this.stringEncoder), TuplesKt.to(BigDecimal.class, (Object)this.stringEncoder), TuplesKt.to(BigDecimal.class, (Object)this.stringEncoder), TuplesKt.to(BigInteger.class, (Object)this.stringEncoder), TuplesKt.to(Byte.TYPE, (Object)ByteEncoder.INSTANCE), TuplesKt.to(Byte.class, (Object)ByteEncoder.INSTANCE), TuplesKt.to(Short.TYPE, (Object)ShortEncoder.INSTANCE), TuplesKt.to(Short.class, (Object)ShortEncoder.INSTANCE), TuplesKt.to(Integer.TYPE, (Object)IntegerEncoder.INSTANCE), TuplesKt.to(Integer.class, (Object)IntegerEncoder.INSTANCE), TuplesKt.to(Long.TYPE, (Object)LongEncoder.INSTANCE), TuplesKt.to(Long.class, (Object)LongEncoder.INSTANCE), TuplesKt.to(Float.TYPE, (Object)FloatEncoder.INSTANCE), TuplesKt.to(Float.class, (Object)FloatEncoder.INSTANCE), TuplesKt.to(Double.TYPE, (Object)DoubleEncoder.INSTANCE), TuplesKt.to(Double.class, (Object)DoubleEncoder.INSTANCE), TuplesKt.to(LocalDateTime.class, (Object)LocalDateTimeEncoder.INSTANCE), TuplesKt.to(OffsetDateTime.class, (Object)DateTimeEncoder.INSTANCE), TuplesKt.to(LocalDate.class, (Object)LocalDateEncoder.INSTANCE), TuplesKt.to(java.util.Date.class, (Object)JavaDateEncoder.INSTANCE), TuplesKt.to(Timestamp.class, (Object)SQLTimestampEncoder.INSTANCE), TuplesKt.to(Date.class, (Object)SQLDateEncoder.INSTANCE), TuplesKt.to(Time.class, (Object)SQLTimeEncoder.INSTANCE), TuplesKt.to(Duration.class, (Object)DurationEncoder.INSTANCE), TuplesKt.to(byte[].class, (Object)ByteArrayEncoder.INSTANCE), TuplesKt.to(Boolean.TYPE, (Object)BooleanEncoder.INSTANCE), TuplesKt.to(Boolean.class, (Object)BooleanEncoder.INSTANCE)};
        this.encoders = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final BinaryEncoder encoderFor(@NotNull Object v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Map<Class<?>, BinaryEncoder> map = this.encoders;
        BinaryEncoder binaryEncoder = map.get(v.getClass());
        if (binaryEncoder == null) {
            BinaryEncoder binaryEncoder2;
            boolean bl = false;
            Object object = v;
            if (object instanceof CharSequence) {
                binaryEncoder2 = this.stringEncoder;
            } else if (object instanceof BigInteger) {
                binaryEncoder2 = this.stringEncoder;
            } else if (object instanceof BigDecimal) {
                binaryEncoder2 = this.stringEncoder;
            } else if (object instanceof OffsetDateTime) {
                binaryEncoder2 = DateTimeEncoder.INSTANCE;
            } else if (object instanceof Instant) {
                binaryEncoder2 = ReadableInstantEncoder.INSTANCE;
            } else if (object instanceof LocalDateTime) {
                binaryEncoder2 = LocalDateTimeEncoder.INSTANCE;
            } else if (object instanceof Timestamp) {
                binaryEncoder2 = SQLTimestampEncoder.INSTANCE;
            } else if (object instanceof Date) {
                binaryEncoder2 = SQLDateEncoder.INSTANCE;
            } else if (object instanceof Calendar) {
                binaryEncoder2 = CalendarEncoder.INSTANCE;
            } else if (object instanceof LocalDate) {
                binaryEncoder2 = LocalDateEncoder.INSTANCE;
            } else if (object instanceof LocalTime) {
                binaryEncoder2 = LocalTimeEncoder.INSTANCE;
            } else if (object instanceof Time) {
                binaryEncoder2 = SQLTimeEncoder.INSTANCE;
            } else if (object instanceof Duration) {
                binaryEncoder2 = DurationEncoder.INSTANCE;
            } else if (object instanceof java.util.Date) {
                binaryEncoder2 = JavaDateEncoder.INSTANCE;
            } else if (object instanceof ByteBuffer) {
                binaryEncoder2 = ByteBufferEncoder.INSTANCE;
            } else if (object instanceof ByteBuf) {
                binaryEncoder2 = ByteBufEncoder.INSTANCE;
            } else {
                String reason$iv = "couldn't find mapping for " + v.getClass();
                boolean $i$f$XXX = false;
                throw new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
            }
            return binaryEncoder2;
        }
        return binaryEncoder;
    }
}

