/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.column;

import com.github.jasync.sql.db.column.ColumnDecoder;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import com.github.jasync.sql.db.util.DurationUtilsKt;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/github/jasync/sql/db/mysql/column/TimeDecoder;", "Lcom/github/jasync/sql/db/column/ColumnDecoder;", "()V", "decode", "Ljava/time/Duration;", "value", "", "jasync-mysql"})
public final class TimeDecoder
implements ColumnDecoder {
    @NotNull
    public static final TimeDecoder INSTANCE = new TimeDecoder();

    private TimeDecoder() {
    }

    @NotNull
    public Duration decode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        char[] cArray = new char[]{':'};
        List pieces = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'.'};
        List secondsAndMillis = StringsKt.split$default((CharSequence)((CharSequence)pieces.get(2)), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        Pair parts = CollectionsUtilsKt.getLength((Collection)secondsAndMillis) == 2 ? TuplesKt.to((Object)Integer.parseInt((String)secondsAndMillis.get(0)), (Object)Integer.parseInt((String)secondsAndMillis.get(1))) : TuplesKt.to((Object)Integer.parseInt((String)secondsAndMillis.get(0)), (Object)0);
        int hours = Integer.parseInt((String)pieces.get(0));
        int minutes = Integer.parseInt((String)pieces.get(1));
        Duration duration = DurationUtilsKt.getHours((int)hours).plus(DurationUtilsKt.getMinutes((int)minutes)).plus(DurationUtilsKt.getSeconds((int)((Number)parts.getFirst()).intValue())).plus(DurationUtilsKt.getMillis((int)((Number)parts.getSecond()).intValue()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"hours.hours + minutes.mi\u2026nds + parts.second.millis");
        return duration;
    }

    @Nullable
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        return ColumnDecoder.DefaultImpls.decode((ColumnDecoder)this, (ColumnData)kind, (ByteBuf)value, (Charset)charset);
    }

    public boolean supportsStringDecoding() {
        return ColumnDecoder.DefaultImpls.supportsStringDecoding((ColumnDecoder)this);
    }
}

