/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.encoder;

import com.github.jasync.sql.db.mysql.encoder.MessageEncoder;
import com.github.jasync.sql.db.mysql.message.client.CapabilityRequestMessage;
import com.github.jasync.sql.db.mysql.message.client.ClientMessage;
import com.github.jasync.sql.db.mysql.util.CapabilityFlag;
import com.github.jasync.sql.db.mysql.util.CharsetMapper;
import com.github.jasync.sql.db.util.ByteBufferUtils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/SSLRequestEncoder;", "Lcom/github/jasync/sql/db/mysql/encoder/MessageEncoder;", "charset", "Ljava/nio/charset/Charset;", "charsetMapper", "Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;", "(Ljava/nio/charset/Charset;Lcom/github/jasync/sql/db/mysql/util/CharsetMapper;)V", "encode", "Lio/netty/buffer/ByteBuf;", "message", "Lcom/github/jasync/sql/db/mysql/message/client/ClientMessage;", "Companion", "jasync-mysql"})
public final class SSLRequestEncoder
implements MessageEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset charset;
    @NotNull
    private final CharsetMapper charsetMapper;
    private static final int MAX_3_BYTES = 0xFFFFFF;
    @NotNull
    private static final byte[] PADDING;

    public SSLRequestEncoder(@NotNull Charset charset, @NotNull CharsetMapper charsetMapper) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)charsetMapper, (String)"charsetMapper");
        this.charset = charset;
        this.charsetMapper = charsetMapper;
    }

    @Override
    @NotNull
    public ByteBuf encode(@NotNull ClientMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!(message instanceof CapabilityRequestMessage)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int clientCapabilities = 0;
        for (CapabilityFlag flag : ((CapabilityRequestMessage)message).getFlags()) {
            clientCapabilities |= flag.getValue();
        }
        ByteBuf buffer = ByteBufferUtils.packetBuffer();
        buffer.writeInt(clientCapabilities);
        buffer.writeInt(0xFFFFFF);
        buffer.writeByte(this.charsetMapper.toInt(this.charset));
        buffer.writeBytes(PADDING);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        return buffer;
    }

    static {
        int n = 0;
        byte[] byArray = new byte[23];
        while (n < 23) {
            int n2 = n++;
            byArray[n2] = 0;
        }
        PADDING = byArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/jasync/sql/db/mysql/encoder/SSLRequestEncoder$Companion;", "", "()V", "MAX_3_BYTES", "", "PADDING", "", "jasync-mysql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

