/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.mysql.message.server;

import com.github.jasync.sql.db.mysql.message.server.ServerMessage;
import com.github.jasync.sql.db.mysql.util.CapabilityFlag;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003JO\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\t\u0010%\u001a\u00020\tH\u00d6\u0001J\u0006\u0010&\u001a\u00020\"J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006("}, d2={"Lcom/github/jasync/sql/db/mysql/message/server/HandshakeMessage;", "Lcom/github/jasync/sql/db/mysql/message/server/ServerMessage;", "serverVersion", "", "connectionId", "", "seed", "", "serverCapabilities", "", "characterSet", "statusFlags", "authenticationMethod", "(Ljava/lang/String;J[BIIILjava/lang/String;)V", "getAuthenticationMethod", "()Ljava/lang/String;", "getCharacterSet", "()I", "getConnectionId", "()J", "getSeed", "()[B", "getServerCapabilities", "getServerVersion", "getStatusFlags", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "supportsSSL", "toString", "jasync-mysql"})
public final class HandshakeMessage
extends ServerMessage {
    @NotNull
    private final String serverVersion;
    private final long connectionId;
    @NotNull
    private final byte[] seed;
    private final int serverCapabilities;
    private final int characterSet;
    private final int statusFlags;
    @NotNull
    private final String authenticationMethod;

    public HandshakeMessage(@NotNull String serverVersion, long connectionId, @NotNull byte[] seed, int serverCapabilities, int characterSet, int statusFlags, @NotNull String authenticationMethod) {
        Intrinsics.checkNotNullParameter((Object)serverVersion, (String)"serverVersion");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)authenticationMethod, (String)"authenticationMethod");
        super(10);
        this.serverVersion = serverVersion;
        this.connectionId = connectionId;
        this.seed = seed;
        this.serverCapabilities = serverCapabilities;
        this.characterSet = characterSet;
        this.statusFlags = statusFlags;
        this.authenticationMethod = authenticationMethod;
    }

    @NotNull
    public final String getServerVersion() {
        return this.serverVersion;
    }

    public final long getConnectionId() {
        return this.connectionId;
    }

    @NotNull
    public final byte[] getSeed() {
        return this.seed;
    }

    public final int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public final int getCharacterSet() {
        return this.characterSet;
    }

    public final int getStatusFlags() {
        return this.statusFlags;
    }

    @NotNull
    public final String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public final boolean supportsSSL() {
        return (CapabilityFlag.CLIENT_SSL.getValue() & this.serverCapabilities) != 0;
    }

    @NotNull
    public final String component1() {
        return this.serverVersion;
    }

    public final long component2() {
        return this.connectionId;
    }

    @NotNull
    public final byte[] component3() {
        return this.seed;
    }

    public final int component4() {
        return this.serverCapabilities;
    }

    public final int component5() {
        return this.characterSet;
    }

    public final int component6() {
        return this.statusFlags;
    }

    @NotNull
    public final String component7() {
        return this.authenticationMethod;
    }

    @NotNull
    public final HandshakeMessage copy(@NotNull String serverVersion, long connectionId, @NotNull byte[] seed, int serverCapabilities, int characterSet, int statusFlags, @NotNull String authenticationMethod) {
        Intrinsics.checkNotNullParameter((Object)serverVersion, (String)"serverVersion");
        Intrinsics.checkNotNullParameter((Object)seed, (String)"seed");
        Intrinsics.checkNotNullParameter((Object)authenticationMethod, (String)"authenticationMethod");
        return new HandshakeMessage(serverVersion, connectionId, seed, serverCapabilities, characterSet, statusFlags, authenticationMethod);
    }

    public static /* synthetic */ HandshakeMessage copy$default(HandshakeMessage handshakeMessage, String string, long l, byte[] byArray, int n, int n2, int n3, String string2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string = handshakeMessage.serverVersion;
        }
        if ((n4 & 2) != 0) {
            l = handshakeMessage.connectionId;
        }
        if ((n4 & 4) != 0) {
            byArray = handshakeMessage.seed;
        }
        if ((n4 & 8) != 0) {
            n = handshakeMessage.serverCapabilities;
        }
        if ((n4 & 0x10) != 0) {
            n2 = handshakeMessage.characterSet;
        }
        if ((n4 & 0x20) != 0) {
            n3 = handshakeMessage.statusFlags;
        }
        if ((n4 & 0x40) != 0) {
            string2 = handshakeMessage.authenticationMethod;
        }
        return handshakeMessage.copy(string, l, byArray, n, n2, n3, string2);
    }

    @NotNull
    public String toString() {
        return "HandshakeMessage(serverVersion=" + this.serverVersion + ", connectionId=" + this.connectionId + ", seed=" + Arrays.toString(this.seed) + ", serverCapabilities=" + this.serverCapabilities + ", characterSet=" + this.characterSet + ", statusFlags=" + this.statusFlags + ", authenticationMethod=" + this.authenticationMethod + ')';
    }

    public int hashCode() {
        int result2 = this.serverVersion.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.connectionId);
        result2 = result2 * 31 + Arrays.hashCode(this.seed);
        result2 = result2 * 31 + Integer.hashCode(this.serverCapabilities);
        result2 = result2 * 31 + Integer.hashCode(this.characterSet);
        result2 = result2 * 31 + Integer.hashCode(this.statusFlags);
        result2 = result2 * 31 + this.authenticationMethod.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HandshakeMessage)) {
            return false;
        }
        HandshakeMessage handshakeMessage = (HandshakeMessage)other;
        if (!Intrinsics.areEqual((Object)this.serverVersion, (Object)handshakeMessage.serverVersion)) {
            return false;
        }
        if (this.connectionId != handshakeMessage.connectionId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.seed, (Object)handshakeMessage.seed)) {
            return false;
        }
        if (this.serverCapabilities != handshakeMessage.serverCapabilities) {
            return false;
        }
        if (this.characterSet != handshakeMessage.characterSet) {
            return false;
        }
        if (this.statusFlags != handshakeMessage.statusFlags) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.authenticationMethod, (Object)handshakeMessage.authenticationMethod);
    }
}

