/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.util;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public interface Cache<K, V> {
    public V get(K var1, Supplier<V> var2);

    public static class UnboundAtomicMapCache<K, V>
    implements Cache<K, V> {
        private final AtomicReference<HashMap<K, V>> cache = new AtomicReference(new HashMap());

        @Override
        public V get(K key, Supplier<V> onMiss) {
            return this.cache.updateAndGet(m -> {
                if (!m.containsKey(key)) {
                    HashMap nm = new HashMap(m);
                    nm.put(key, onMiss.get());
                    return nm;
                }
                return m;
            }).get(key);
        }
    }
}

