/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikolaybespalov.winswmavenplugin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import sun.net.www.protocol.file.FileURLConnection;

public class Utils {
    public static void copyResourcesRecursively(URL originUrl, File destination) throws IOException {
        URLConnection urlConnection = originUrl.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            Utils.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
        } else if (urlConnection instanceof FileURLConnection) {
            FileUtils.copyDirectory((File)new File(originUrl.getPath()), (File)destination);
        } else {
            throw new IOException("URLConnection[" + urlConnection.getClass().getSimpleName() + "] is not a recognized/implemented connection type.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (entry.isDirectory()) continue;
            InputStream entryInputStream = null;
            try {
                entryInputStream = jarFile.getInputStream(entry);
                FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
            }
            finally {
                IOUtils.closeQuietly((Closeable)entryInputStream, null);
            }
        }
    }
}

