/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikolaybespalov.winswmavenplugin;

import com.github.nikolaybespalov.winswmavenplugin.Utils;
import com.github.nikolaybespalov.winswmavenplugin.rc.FileInfo;
import com.github.nikolaybespalov.winswmavenplugin.rc.RcFile;
import com.github.nikolaybespalov.winswmavenplugin.rc.RcFileWriter;
import com.github.nikolaybespalov.winswmavenplugin.xml.ConfigurationFile;
import com.github.nikolaybespalov.winswmavenplugin.xml.ConfigurationFileWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="winsw", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class WinswMojo
extends AbstractMojo {
    public static final String WINSW_ARTIFACT_REPO = "https://repo.jenkins-ci.org/releases/";
    public static final String WINSW_GROUP_ID = "com.sun.winsw";
    public static final String WINSW_ARTIFACT_ID = "winsw";
    public static final String WINSW_LOCAL_REPO_NAME = "winsw-repository";
    public static final String WINSW_REPO_JAR = "jar";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="https://repo.jenkins-ci.org/releases/")
    private String winswRepo;
    @Parameter(defaultValue="2.9.0")
    private String winswVersion;
    @Parameter(defaultValue="bin")
    private String winswClassifier;
    @Parameter(defaultValue="${project.build.finalName}.exe")
    private String executableFileName;
    @Parameter
    private File executableFilePath;
    @Parameter(defaultValue="${project.build.finalName}.xml")
    private String configurationFileName;
    @Parameter
    private File configurationFilePath;
    @Parameter
    private ConfigurationFile configurationFile;
    @Parameter
    private RcFile rcFile;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create " + this.outputDirectory);
        }
        this.processConfigurationFile();
        this.processExeFile();
    }

    private void processConfigurationFile() throws MojoExecutionException {
        if (this.configurationFilePath == null) {
            this.createConfigurationFile();
        } else {
            this.copyConfigurationFile();
        }
    }

    private void createConfigurationFile() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Creating configuration file");
        if (this.configurationFile == null) {
            this.configurationFile = new ConfigurationFile(this.mavenProject.getArtifactId(), this.mavenProject.getName(), null, "java", "-jar " + this.mavenProject.getBuild().getFinalName() + ".jar");
        }
        File file = new File(this.outputDirectory, this.configurationFileName);
        try (FileWriter fileWriter = new FileWriter(file);){
            ConfigurationFileWriter configurationFileWriter = new ConfigurationFileWriter(this.configurationFile);
            configurationFileWriter.writeTo(fileWriter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write configuration file " + file, (Exception)e);
        }
    }

    private void copyConfigurationFile() throws MojoExecutionException {
        this.copyFileToOutputDirectory(this.configurationFilePath, this.configurationFileName);
    }

    private void processExeFile() throws MojoExecutionException {
        File destExeFile;
        File exeFile;
        if (this.executableFilePath != null) {
            exeFile = this.copyExecutableFile();
        } else {
            try {
                exeFile = this.downloadWinswBinArtifact();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to download winsw artifact", (Exception)e);
            }
        }
        File resultExeFile = this.copyExecutableFile(exeFile);
        if (this.rcFile != null) {
            File resFile;
            File rcFile;
            try {
                rcFile = this.writeRcFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write rc file", (Exception)e);
            }
            try {
                resFile = this.buildResFile(rcFile);
            }
            catch (IOException | InterruptedException e) {
                throw new MojoExecutionException("Failed to build res file", e);
            }
            try {
                resultExeFile = this.mergeResFileAndExeFile(resFile, exeFile);
            }
            catch (IOException | InterruptedException e) {
                throw new MojoExecutionException("Failed to merge exe and res file", e);
            }
            this.getLog().info((CharSequence)("The file " + resultExeFile + " was successfully processed."));
        }
        if (!resultExeFile.equals(destExeFile = new File(this.outputDirectory, this.executableFileName))) {
            try {
                this.getLog().debug((CharSequence)"Copying result exe file");
                this.getLog().debug((CharSequence)destExeFile.toString());
                FileUtils.copyFile((File)resultExeFile, (File)destExeFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy exe file", (Exception)e);
            }
        }
    }

    private File copyExecutableFile(File executableFilePath) throws MojoExecutionException {
        if (!executableFilePath.exists()) {
            throw new MojoExecutionException("File not found " + executableFilePath);
        }
        File outputFile = new File(this.outputDirectory, this.executableFileName);
        if (!outputFile.exists()) {
            try {
                FileUtils.copyFile((File)executableFilePath, (File)outputFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy file " + executableFilePath, (Exception)e);
            }
        }
        return outputFile;
    }

    private File copyExecutableFile() throws MojoExecutionException {
        return this.copyExecutableFile(this.executableFilePath);
    }

    private File downloadWinswBinArtifact() throws MojoExecutionException, IOException {
        File winswPath = new File(String.format("%s/%s/%s/%s/%s-%s-%s.exe", this.settings.getLocalRepository(), WINSW_GROUP_ID.replace('.', '/'), WINSW_ARTIFACT_ID, this.winswVersion, WINSW_ARTIFACT_ID, this.winswVersion, this.winswClassifier));
        if (winswPath.exists()) {
            this.getLog().debug((CharSequence)("Use of existing winsw.exe: " + winswPath));
            return winswPath;
        }
        if (this.winswRepo.equals(WINSW_REPO_JAR)) {
            this.getLog().debug((CharSequence)"Extracting WinSW repo");
            File localWinswRepoPath = new File(this.outputDirectory, WINSW_LOCAL_REPO_NAME);
            if (!localWinswRepoPath.mkdirs()) {
                throw new IOException("Could not create winsw-repository");
            }
            URL repositoryUrl = super.getClass().getResource("/repository");
            assert (repositoryUrl != null);
            Utils.copyResourcesRecursively(repositoryUrl, localWinswRepoPath);
            this.getLog().debug((CharSequence)"Downloading winsw.exe file");
            this.downloadWinswBinArtifactFromRepo("file://" + localWinswRepoPath);
        } else {
            this.getLog().debug((CharSequence)"Downloading winsw.exe file");
            this.downloadWinswBinArtifactFromRepo(this.winswRepo);
        }
        return winswPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadWinswBinArtifactFromRepo(String artifactRepo) throws MojoExecutionException, IOException {
        this.getLog().debug((CharSequence)("ARTIFACT_REPO: " + artifactRepo));
        MavenArtifactRepository winswRepository = new MavenArtifactRepository(WINSW_ARTIFACT_ID, artifactRepo, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(false, "never", "fail"), new ArtifactRepositoryPolicy(true, "never", "fail"));
        this.mavenProject.getRemoteArtifactRepositories().add(winswRepository);
        File tmp = File.createTempFile(WINSW_ARTIFACT_ID, ".exe");
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.googlecode.maven-download-plugin"), (String)MojoExecutor.artifactId((String)"download-maven-plugin"), (String)MojoExecutor.version((String)"1.6.3")), (String)MojoExecutor.goal((String)"artifact"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)WINSW_GROUP_ID), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)WINSW_ARTIFACT_ID), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.winswVersion), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"exe"), MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)this.winswClassifier), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)tmp.getParentFile().getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"outputFileName"), (String)tmp.getName())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        finally {
            this.mavenProject.getRemoteArtifactRepositories().remove(winswRepository);
        }
    }

    private File extractFile(String name) throws IOException {
        String resourceNameFormat;
        if (SystemUtils.IS_OS_WINDOWS) {
            resourceNameFormat = SystemUtils.OS_ARCH.contains("x86_64") || SystemUtils.OS_ARCH.contains("amd64") ? "/bin/win32-x86-64/%s.exe" : "/bin/win32-x86/%s.exe";
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            resourceNameFormat = "/bin/macosx-x86-64/%s";
        } else if (SystemUtils.IS_OS_LINUX) {
            resourceNameFormat = "/bin/linux-x86-64/%s";
        } else {
            throw new IOException(String.format("Unsupported platform: %s %s %s", SystemUtils.OS_ARCH, SystemUtils.OS_NAME, SystemUtils.OS_VERSION));
        }
        String resourceName = String.format(resourceNameFormat, name);
        this.getLog().debug((CharSequence)("Extraction " + resourceName));
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);){
            assert (is != null);
            Path path = Files.createTempFile(name, ".exe", new FileAttribute[0]);
            if (!SystemUtils.IS_OS_WINDOWS) {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rwxr-xr-x"));
            }
            this.getLog().debug((CharSequence)path.toString());
            FileUtils.copyInputStreamToFile((InputStream)is, (File)path.toFile());
            File file = path.toFile();
            return file;
        }
    }

    private File writeRcFile() throws IOException {
        this.getLog().debug((CharSequence)"Writing rc file");
        Path path = Files.createTempFile(WINSW_ARTIFACT_ID, ".rc", new FileAttribute[0]);
        this.getLog().debug((CharSequence)path.toString());
        if (this.rcFile.getFileInfo() == null) {
            this.rcFile.setFileInfo(new FileInfo(this.mavenProject.getVersion(), this.mavenProject.getVersion(), this.mavenProject.getVersion(), this.mavenProject.getName(), this.executableFileName, this.mavenProject.getName(), this.mavenProject.getVersion()));
        }
        RcFileWriter rcFileWriter = new RcFileWriter(this.rcFile);
        try (FileWriter fileWriter = new FileWriter(path.toFile());){
            rcFileWriter.writeTo(fileWriter);
        }
        return path.toFile();
    }

    private File buildResFile(File rcFile) throws IOException, InterruptedException {
        this.getLog().debug((CharSequence)"Making res file");
        File windresFile = this.extractFile("windres");
        Path path = Files.createTempFile(WINSW_ARTIFACT_ID, ".res", new FileAttribute[0]);
        this.getLog().debug((CharSequence)path.toString());
        this.executeCommand(windresFile.getAbsolutePath(), SystemUtils.IS_OS_WINDOWS ? "--preprocessor=type" : "--preprocessor=cat", "-J", "rc", "-O", "res", rcFile.getAbsolutePath(), path.toFile().getAbsolutePath());
        return path.toFile();
    }

    private File mergeResFileAndExeFile(File resFile, File exeFile) throws IOException, InterruptedException {
        this.getLog().debug((CharSequence)"Merging res and exe files");
        Path winswMerged = Files.createTempFile("winsw-merged", ".exe", new FileAttribute[0]);
        this.getLog().debug((CharSequence)winswMerged.toString());
        if (SystemUtils.IS_OS_WINDOWS) {
            File resourceHackerFile = this.extractFile("ResourceHacker");
            this.executeCommand(resourceHackerFile.getAbsolutePath(), "-open", exeFile.getAbsolutePath(), "-save", winswMerged.toFile().getAbsolutePath(), "-action", "addoverwrite", "-resource", resFile.getAbsolutePath());
        } else {
            File peresedFile = this.extractFile("peresed");
            this.executeCommand(peresedFile.getAbsolutePath(), "--apply", resFile.getAbsolutePath(), "--output", winswMerged.toFile().getAbsolutePath(), exeFile.getAbsolutePath());
        }
        return winswMerged.toFile();
    }

    private void executeCommand(String ... args) throws IOException, InterruptedException {
        String output;
        this.getLog().debug((CharSequence)Arrays.toString(args));
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        try (InputStream is = process.getInputStream();){
            output = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IOException(output);
        }
    }

    private void copyFileToOutputDirectory(File filePath, String fileName) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Copying file " + filePath));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"3.2.0")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.outputDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"resources"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)filePath.getParent()), MojoExecutor.element((String)"include", (String)filePath.getName()), MojoExecutor.element((String)"filtering", (String)"true")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        File outputFile = new File(this.outputDirectory, fileName);
        try {
            FileUtils.moveFile((File)new File(this.outputDirectory, filePath.getName()), (File)outputFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to move file " + outputFile, (Exception)e);
        }
    }
}

