/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikolaybespalov.winswmavenplugin.rc;

import com.github.nikolaybespalov.winswmavenplugin.rc.FileInfo;
import com.github.nikolaybespalov.winswmavenplugin.rc.RcFile;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class RcFileWriter {
    private final RcFile rcFile;

    public RcFileWriter(RcFile rcFile) {
        this.rcFile = rcFile;
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeHeader(writer);
        writer.append("\n\n");
        this.writeVersionInfo(writer);
        writer.append("\n\n");
        this.writeIcon(writer);
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.append(String.format("LANGUAGE %s, %s", this.rcFile.getLang(), this.rcFile.getSubLang()));
    }

    private void writeVersionInfo(Writer writer) throws IOException {
        FileInfo fi = this.rcFile.getFileInfo();
        writer.append("1 VERSIONINFO\n");
        writer.append(String.format(" FILEVERSION %s\n", this.prepareVersion(fi.getFileVersion())));
        writer.append(String.format(" PRODUCTVERSION %s\n", this.prepareVersion(fi.getProductVersion())));
        writer.append(" FILEFLAGSMASK 0x0\n");
        writer.append(" FILEOS 0x4\n");
        writer.append(" FILETYPE 0x1\n");
        writer.append("BEGIN\n");
        writer.append("  BLOCK ").append("\"StringFileInfo\"\n");
        writer.append("  BEGIN\n");
        writer.append("    BLOCK ").append("\"000004b0\"\n");
        writer.append("    BEGIN\n");
        this.writeStringValue(writer, "Comments", fi.getComments());
        this.writeStringValue(writer, "CompanyName", fi.getCompanyName());
        this.writeStringValue(writer, "FileDescription", fi.getFileDescription());
        this.writeStringValue(writer, "FileVersion", fi.getTxtFileVersion());
        this.writeStringValue(writer, "InternalName", fi.getInternalName());
        this.writeStringValue(writer, "LegalCopyright", fi.getCopyright());
        this.writeStringValue(writer, "LegalTrademarks", fi.getTrademarks());
        this.writeStringValue(writer, "OriginalFilename", fi.getOriginalFilename());
        this.writeStringValue(writer, "ProductName", fi.getProductName());
        this.writeStringValue(writer, "ProductVersion", fi.getTxtProductVersion());
        writer.append("    END\n");
        writer.append("  END\n");
        writer.append("  BLOCK \"VarFileInfo\"\n");
        writer.append("  BEGIN\n");
        writer.append("    VALUE \"Translation\", 0x0, 0x04b0\n");
        writer.append("  END\n");
        writer.append("END");
    }

    private void writeIcon(Writer writer) throws IOException {
        if (StringUtils.isEmpty((CharSequence)this.rcFile.getIcon())) {
            return;
        }
        writer.append(String.format("1 ICON DISCARDABLE \"%s\"", FilenameUtils.separatorsToUnix((String)this.rcFile.getIcon())));
    }

    private String prepareVersion(String version) {
        return this.complementVersion(version.replaceAll("-SNAPSHOT", "").replaceAll("\\.", ", "));
    }

    private String complementVersion(String version) {
        StringBuilder versionBuilder = new StringBuilder(version);
        while (StringUtils.countMatches((CharSequence)versionBuilder, (char)',') < 3) {
            versionBuilder.append(", 0");
        }
        return versionBuilder.toString();
    }

    private void writeStringValue(Writer writer, String key, String value) throws IOException {
        if (value == null) {
            return;
        }
        writer.append(String.format("      VALUE \"%s\", \"%s\"", key, value));
        writer.append("\n");
    }
}

