/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.jbehave.junit.monitoring;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.junit.JUnitStory;

public class StoryPathsExtractor {
    private final ConfigurableEmbedder configurableEmbedder;

    public StoryPathsExtractor(ConfigurableEmbedder configurableEmbedder) {
        this.configurableEmbedder = configurableEmbedder;
    }

    public List<String> getStoryPaths() throws ReflectiveOperationException {
        if (this.configurableEmbedder instanceof JUnitStories) {
            return this.extractStoryPathsFromJUnitStories();
        }
        if (this.configurableEmbedder instanceof JUnitStory) {
            return this.extractStoryPathsFromJUnitStory();
        }
        throw new IllegalArgumentException("Only ConfigurableEmbedder of types JUnitStory and JUnitStories is supported");
    }

    private List<String> extractStoryPathsFromJUnitStories() throws ReflectiveOperationException {
        Method method = StoryPathsExtractor.makeStoryPathsMethodPublic(this.configurableEmbedder.getClass());
        return (List)method.invoke((Object)this.configurableEmbedder, (Object[])null);
    }

    private static Method makeStoryPathsMethodPublic(Class<? extends JUnitStories> clazz) throws NoSuchMethodException {
        try {
            Method method = clazz.getDeclaredMethod("storyPaths", null);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            Class<? extends JUnitStories> superclass = clazz.getSuperclass();
            if (superclass != null && JUnitStories.class.isAssignableFrom(superclass)) {
                return StoryPathsExtractor.makeStoryPathsMethodPublic(superclass);
            }
            throw e;
        }
    }

    private List<String> extractStoryPathsFromJUnitStory() {
        StoryPathResolver storyPathResolver = this.configurableEmbedder.configuredEmbedder().configuration().storyPathResolver();
        return Collections.singletonList(storyPathResolver.resolve(this.configurableEmbedder.getClass()));
    }
}

