/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseException;
import com.google.firebase.internal.NonNull;

public class FirebaseAuthException
extends FirebaseException {
    private final String errorCode;

    public FirebaseAuthException(@NonNull String errorCode, @NonNull String detailMessage) {
        this(errorCode, detailMessage, null);
    }

    public FirebaseAuthException(@NonNull String errorCode, @NonNull String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)errorCode) ? 1 : 0) != 0);
        this.errorCode = errorCode;
    }

    @NonNull
    public String getErrorCode() {
        return this.errorCode;
    }
}

