/*
 * Decompiled with CFR 0.152.
 */
package com.google.gradle.osdetector;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import kr.motd.maven.os.Detector;
import kr.motd.maven.os.FileOperationProvider;
import kr.motd.maven.os.SystemPropertyOperationProvider;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OsDetector {
    private static final Logger logger = LoggerFactory.getLogger((String)OsDetector.class.getName());
    private final Project project;
    private final List<String> classifierWithLikes = new ArrayList<String>();
    private Impl impl;

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Inject
    public abstract ProjectLayout getProjectLayout();

    public OsDetector(Project project) {
        this.project = project;
    }

    public String getOs() {
        return (String)this.getImpl().detectedProperties.get("os.detected.name");
    }

    public String getArch() {
        return (String)this.getImpl().detectedProperties.get("os.detected.arch");
    }

    public String getClassifier() {
        return (String)this.getImpl().detectedProperties.get("os.detected.classifier");
    }

    public Release getRelease() {
        Impl impl = this.getImpl();
        Object releaseId = impl.detectedProperties.get("os.detected.release");
        if (releaseId == null) {
            return null;
        }
        return new Release(impl);
    }

    public synchronized void setClassifierWithLikes(List<String> classifierWithLikes) {
        if (this.impl != null) {
            throw new IllegalStateException("classifierWithLikes must be set before osdetector is read.");
        }
        this.classifierWithLikes.clear();
        this.classifierWithLikes.addAll(classifierWithLikes);
    }

    private synchronized Impl getImpl() {
        if (this.impl == null) {
            this.impl = GradleVersion.current().compareTo(GradleVersion.version((String)"6.5")) >= 0 ? new Impl(this.classifierWithLikes, new ConfigurationTimeSafeSystemPropertyOperations(), new ConfigurationTimeSafeFileOperations()) : new Impl(this.classifierWithLikes);
        }
        return this.impl;
    }

    private final class ConfigurationTimeSafeFileOperations
    implements FileOperationProvider {
        private ConfigurationTimeSafeFileOperations() {
        }

        public InputStream readFile(String fileName) throws IOException {
            RegularFile file = OsDetector.this.getProjectLayout().getProjectDirectory().file(fileName);
            byte[] bytes = (byte[])OsDetector.this.getProviderFactory().fileContents(file).getAsBytes().forUseAtConfigurationTime().getOrNull();
            if (bytes == null) {
                throw new FileNotFoundException(fileName + " not exist");
            }
            return new ByteArrayInputStream(bytes);
        }
    }

    private final class ConfigurationTimeSafeSystemPropertyOperations
    implements SystemPropertyOperationProvider {
        private ConfigurationTimeSafeSystemPropertyOperations() {
        }

        public String getSystemProperty(String name) {
            return (String)OsDetector.this.getProviderFactory().systemProperty(name).forUseAtConfigurationTime().getOrNull();
        }

        public String getSystemProperty(String name, String def) {
            return (String)OsDetector.this.getProviderFactory().systemProperty(name).forUseAtConfigurationTime().getOrElse((Object)def);
        }

        public String setSystemProperty(String name, String value) {
            return null;
        }
    }

    private static class Impl
    extends Detector {
        final Properties detectedProperties = new Properties();

        Impl(List<String> classifierWithLikes, SystemPropertyOperationProvider sysPropOps, FileOperationProvider fsOps) {
            super(sysPropOps, fsOps);
            this.detect(this.detectedProperties, classifierWithLikes);
        }

        Impl(List<String> classifierWithLikes) {
            this.detect(this.detectedProperties, classifierWithLikes);
        }

        protected void log(String message) {
            logger.info(message);
        }

        protected void logProperty(String name, String value) {
            logger.info(name + "=" + value);
        }
    }

    public static class Release {
        private final Impl impl;

        private Release(Impl impl) {
            this.impl = impl;
        }

        public String getId() {
            return (String)this.impl.detectedProperties.get("os.detected.release");
        }

        public String getVersion() {
            return (String)this.impl.detectedProperties.get("os.detected.release.version");
        }

        public boolean isLike(String baseRelease) {
            return this.impl.detectedProperties.containsKey("os.detected.release.like." + baseRelease);
        }
    }
}

