/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalCalc;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.Pair;

public class ProjectCalcMergeRule
extends RelOptRule
implements TransformationRule {
    public static final ProjectCalcMergeRule INSTANCE = new ProjectCalcMergeRule(RelFactories.LOGICAL_BUILDER);

    public ProjectCalcMergeRule(RelBuilderFactory relBuilderFactory) {
        super(ProjectCalcMergeRule.operand(LogicalProject.class, ProjectCalcMergeRule.operand(LogicalCalc.class, ProjectCalcMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalCalc calc = (LogicalCalc)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        RexProgram program = RexProgram.create(calc.getRowType(), project.getProjects(), null, project.getRowType(), cluster.getRexBuilder());
        if (RexOver.containsOver(program)) {
            LogicalCalc projectAsCalc = LogicalCalc.create(calc, program);
            call.transformTo(projectAsCalc);
            return;
        }
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexProgramBuilder progBuilder = new RexProgramBuilder(calc.getRowType(), rexBuilder);
        for (Pair<RexNode, String> field : project.getNamedProjects()) {
            progBuilder.addProject((RexNode)field.left, (String)field.right);
        }
        RexProgram topProgram = progBuilder.getProgram();
        RexProgram bottomProgram = calc.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        LogicalCalc newCalc = LogicalCalc.create(calc.getInput(), mergedProgram);
        call.transformTo(newCalc);
    }
}

