/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.rules.PushProjector;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProjectJoinTransposeRule
extends RelOptRule
implements TransformationRule {
    public static final ProjectJoinTransposeRule INSTANCE = new ProjectJoinTransposeRule(LogicalProject.class, LogicalJoin.class, expr -> !(expr instanceof RexOver), RelFactories.LOGICAL_BUILDER);
    private final PushProjector.ExprCondition preserveExprCondition;

    public ProjectJoinTransposeRule(Class<? extends Project> projectClass, Class<? extends Join> joinClass, PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relFactory) {
        super(ProjectJoinTransposeRule.operand(projectClass, ProjectJoinTransposeRule.operand(joinClass, ProjectJoinTransposeRule.any()), new RelOptRuleOperand[0]), relFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(final RelOptRuleCall call) {
        RelTraitSet traits;
        List<RelCollation> originCollations;
        Project origProj = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        if (!join.getJoinType().projectsRight()) {
            return;
        }
        RexNode joinFilter = join.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall rexCall) {
                RexNode node = super.visitCall(rexCall);
                if (!(node instanceof RexCall)) {
                    return node;
                }
                return RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)node, call.builder().getRexBuilder());
            }
        });
        PushProjector pushProject = new PushProjector(origProj, joinFilter, join, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (joinFilter != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(joinFilter, projJoinFieldList, adjustments);
        }
        if ((originCollations = (traits = join.getTraitSet()).getTraits(RelCollationTraitDef.INSTANCE)) != null && !originCollations.isEmpty()) {
            ArrayList<RelCollation> newCollations = new ArrayList<RelCollation>();
            int originLeftCnt = join.getLeft().getRowType().getFieldCount();
            Mappings.TargetMapping leftMapping = RelOptUtil.permutationPushDownProject(leftProjRel.getProjects(), join.getLeft().getRowType(), 0, 0);
            Mappings.TargetMapping rightMapping = RelOptUtil.permutationPushDownProject(rightProjRel.getProjects(), join.getRight().getRowType(), originLeftCnt, leftProjRel.getRowType().getFieldCount());
            for (RelCollation collation : originCollations) {
                RelFieldCollation relFieldCollation;
                int fieldIndex;
                Mappings.TargetMapping mapping;
                RelFieldCollation newFieldCollation;
                ArrayList<RelFieldCollation> fc = new ArrayList<RelFieldCollation>();
                List<RelFieldCollation> fieldCollations = collation.getFieldCollations();
                Iterator<RelFieldCollation> iterator = fieldCollations.iterator();
                while (iterator.hasNext() && (newFieldCollation = RexUtil.apply(mapping = (fieldIndex = (relFieldCollation = iterator.next()).getFieldIndex()) < originLeftCnt ? leftMapping : rightMapping, relFieldCollation)) != null) {
                    fc.add(newFieldCollation);
                }
                newCollations.add(RelCollations.of(fc));
            }
            if (!newCollations.isEmpty()) {
                traits = traits.replace(newCollations);
            }
        }
        Join newJoinRel = join.copy(traits, newJoinFilter, leftProjRel, rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

