/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexSqlConvertlet;
import com.hazelcast.org.apache.calcite.rex.RexSqlReflectiveConvertletTable;
import com.hazelcast.org.apache.calcite.rex.RexToSqlNodeConverter;
import com.hazelcast.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlCaseOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlLibraryOperators;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RexSqlStandardConvertletTable
extends RexSqlReflectiveConvertletTable {
    public RexSqlStandardConvertletTable() {
        this.registerEquivOp(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        this.registerEquivOp(SqlStdOperatorTable.GREATER_THAN);
        this.registerEquivOp(SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
        this.registerEquivOp(SqlStdOperatorTable.LESS_THAN);
        this.registerEquivOp(SqlStdOperatorTable.EQUALS);
        this.registerEquivOp(SqlStdOperatorTable.NOT_EQUALS);
        this.registerEquivOp(SqlStdOperatorTable.AND);
        this.registerEquivOp(SqlStdOperatorTable.OR);
        this.registerEquivOp(SqlStdOperatorTable.NOT_IN);
        this.registerEquivOp(SqlStdOperatorTable.IN);
        this.registerEquivOp(SqlStdOperatorTable.LIKE);
        this.registerEquivOp(SqlStdOperatorTable.NOT_LIKE);
        this.registerEquivOp(SqlStdOperatorTable.SIMILAR_TO);
        this.registerEquivOp(SqlStdOperatorTable.NOT_SIMILAR_TO);
        this.registerEquivOp(SqlStdOperatorTable.POSIX_REGEX_CASE_SENSITIVE);
        this.registerEquivOp(SqlStdOperatorTable.POSIX_REGEX_CASE_INSENSITIVE);
        this.registerEquivOp(SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_SENSITIVE);
        this.registerEquivOp(SqlStdOperatorTable.NEGATED_POSIX_REGEX_CASE_INSENSITIVE);
        this.registerEquivOp(SqlStdOperatorTable.PLUS);
        this.registerEquivOp(SqlStdOperatorTable.MINUS);
        this.registerEquivOp(SqlStdOperatorTable.MULTIPLY);
        this.registerEquivOp(SqlStdOperatorTable.DIVIDE);
        this.registerEquivOp(SqlStdOperatorTable.NOT);
        this.registerEquivOp(SqlStdOperatorTable.IS_NOT_NULL);
        this.registerEquivOp(SqlStdOperatorTable.IS_NULL);
        this.registerEquivOp(SqlStdOperatorTable.IS_NOT_TRUE);
        this.registerEquivOp(SqlStdOperatorTable.IS_TRUE);
        this.registerEquivOp(SqlStdOperatorTable.IS_NOT_FALSE);
        this.registerEquivOp(SqlStdOperatorTable.IS_FALSE);
        this.registerEquivOp(SqlStdOperatorTable.IS_NOT_UNKNOWN);
        this.registerEquivOp(SqlStdOperatorTable.IS_UNKNOWN);
        this.registerEquivOp(SqlStdOperatorTable.UNARY_MINUS);
        this.registerEquivOp(SqlStdOperatorTable.UNARY_PLUS);
        this.registerCaseOp(SqlStdOperatorTable.CASE);
        this.registerEquivOp(SqlStdOperatorTable.CONCAT);
        this.registerEquivOp(SqlStdOperatorTable.BETWEEN);
        this.registerEquivOp(SqlStdOperatorTable.SYMMETRIC_BETWEEN);
        this.registerEquivOp(SqlStdOperatorTable.NOT_BETWEEN);
        this.registerEquivOp(SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN);
        this.registerEquivOp(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM);
        this.registerEquivOp(SqlStdOperatorTable.IS_DISTINCT_FROM);
        this.registerEquivOp(SqlStdOperatorTable.MINUS_DATE);
        this.registerEquivOp(SqlStdOperatorTable.EXTRACT);
        this.registerEquivOp(SqlStdOperatorTable.SUBSTRING);
        this.registerEquivOp(SqlStdOperatorTable.CONVERT);
        this.registerEquivOp(SqlStdOperatorTable.TRANSLATE);
        this.registerEquivOp(SqlStdOperatorTable.OVERLAY);
        this.registerEquivOp(SqlStdOperatorTable.TRIM);
        this.registerEquivOp(SqlLibraryOperators.TRANSLATE3);
        this.registerEquivOp(SqlStdOperatorTable.POSITION);
        this.registerEquivOp(SqlStdOperatorTable.CHAR_LENGTH);
        this.registerEquivOp(SqlStdOperatorTable.CHARACTER_LENGTH);
        this.registerEquivOp(SqlStdOperatorTable.UPPER);
        this.registerEquivOp(SqlStdOperatorTable.LOWER);
        this.registerEquivOp(SqlStdOperatorTable.INITCAP);
        this.registerEquivOp(SqlStdOperatorTable.POWER);
        this.registerEquivOp(SqlStdOperatorTable.SQRT);
        this.registerEquivOp(SqlStdOperatorTable.MOD);
        this.registerEquivOp(SqlStdOperatorTable.LN);
        this.registerEquivOp(SqlStdOperatorTable.LOG10);
        this.registerEquivOp(SqlStdOperatorTable.ABS);
        this.registerEquivOp(SqlStdOperatorTable.EXP);
        this.registerEquivOp(SqlStdOperatorTable.FLOOR);
        this.registerEquivOp(SqlStdOperatorTable.CEIL);
        this.registerEquivOp(SqlStdOperatorTable.NULLIF);
        this.registerEquivOp(SqlStdOperatorTable.COALESCE);
        this.registerTypeAppendOp(SqlStdOperatorTable.CAST);
    }

    public SqlNode convertCall(RexToSqlNodeConverter converter, RexCall call) {
        if (this.get(call) == null) {
            return null;
        }
        SqlOperator op = call.getOperator();
        List<RexNode> operands = call.getOperands();
        SqlNode[] exprs = this.convertExpressionList(converter, operands);
        if (exprs == null) {
            return null;
        }
        return new SqlBasicCall(op, exprs, SqlParserPos.ZERO);
    }

    private SqlNode[] convertExpressionList(RexToSqlNodeConverter converter, List<RexNode> nodes) {
        SqlNode[] exprs = new SqlNode[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            RexNode node = nodes.get(i);
            exprs[i] = converter.convertNode(node);
            if (exprs[i] != null) continue;
            return null;
        }
        return exprs;
    }

    protected void registerEquivOp(SqlOperator op) {
        this.registerOp(op, new EquivConvertlet(op));
    }

    private void registerTypeAppendOp(SqlOperator op) {
        this.registerOp(op, (converter, call) -> {
            SqlNode[] operands = this.convertExpressionList(converter, call.operands);
            if (operands == null) {
                return null;
            }
            ArrayList<SqlNode> operandList = new ArrayList<SqlNode>(Arrays.asList(operands));
            SqlDataTypeSpec typeSpec = SqlTypeUtil.convertTypeToSpec(call.getType());
            operandList.add(typeSpec);
            return new SqlBasicCall(op, operandList.toArray(new SqlNode[0]), SqlParserPos.ZERO);
        });
    }

    private void registerCaseOp(SqlOperator op) {
        this.registerOp(op, (converter, call) -> {
            int i;
            assert (op instanceof SqlCaseOperator);
            SqlNode[] operands = this.convertExpressionList(converter, call.operands);
            if (operands == null) {
                return null;
            }
            SqlNodeList whenList = new SqlNodeList(SqlParserPos.ZERO);
            SqlNodeList thenList = new SqlNodeList(SqlParserPos.ZERO);
            for (i = 0; i < operands.length - 1; ++i) {
                whenList.add(operands[i]);
                thenList.add(operands[++i]);
            }
            SqlNode elseExpr = operands[i];
            return op.createCall(null, SqlParserPos.ZERO, null, whenList, thenList, elseExpr);
        });
    }

    private class EquivConvertlet
    implements RexSqlConvertlet {
        private final SqlOperator op;

        EquivConvertlet(SqlOperator op) {
            this.op = op;
        }

        @Override
        public SqlNode convertCall(RexToSqlNodeConverter converter, RexCall call) {
            SqlNode[] operands = RexSqlStandardConvertletTable.this.convertExpressionList(converter, call.operands);
            if (operands == null) {
                return null;
            }
            return new SqlBasicCall(this.op, operands, SqlParserPos.ZERO);
        }
    }
}

