/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.runtime;

import com.hazelcast.com.fasterxml.jackson.annotation.JsonValue;
import com.hazelcast.com.fasterxml.jackson.core.PrettyPrinter;
import com.hazelcast.com.fasterxml.jackson.core.util.DefaultIndenter;
import com.hazelcast.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.hazelcast.com.jayway.jsonpath.Configuration;
import com.hazelcast.com.jayway.jsonpath.DocumentContext;
import com.hazelcast.com.jayway.jsonpath.JsonPath;
import com.hazelcast.com.jayway.jsonpath.Option;
import com.hazelcast.com.jayway.jsonpath.Predicate;
import com.hazelcast.com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.hazelcast.com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.hazelcast.com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.hazelcast.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.org.apache.calcite.sql.SqlJsonExistsErrorBehavior;
import com.hazelcast.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.org.apache.calcite.util.Static;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonFunctions {
    private static final Pattern JSON_PATH_BASE = Pattern.compile("^\\s*(?<mode>strict|lax)\\s+(?<spec>.+)$", 42);
    private static final JacksonJsonProvider JSON_PATH_JSON_PROVIDER = new JacksonJsonProvider();
    private static final MappingProvider JSON_PATH_MAPPING_PROVIDER = new JacksonMappingProvider();
    private static final PrettyPrinter JSON_PRETTY_PRINTER = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withLinefeed("\n"));

    private JsonFunctions() {
    }

    private static boolean isScalarObject(Object obj) {
        if (obj instanceof Collection) {
            return false;
        }
        return !(obj instanceof Map);
    }

    public static String jsonize(Object input) {
        return JSON_PATH_JSON_PROVIDER.toJson(input);
    }

    public static Object dejsonize(String input) {
        return JSON_PATH_JSON_PROVIDER.parse(input);
    }

    public static JsonValueContext jsonValueExpression(String input) {
        try {
            return JsonValueContext.withJavaObj(JsonFunctions.dejsonize(input));
        }
        catch (Exception e) {
            return JsonValueContext.withException(e);
        }
    }

    public static JsonPathContext jsonApiCommonSyntax(String input) {
        return JsonFunctions.jsonApiCommonSyntax(JsonFunctions.jsonValueExpression(input));
    }

    public static JsonPathContext jsonApiCommonSyntax(JsonValueContext input) {
        return JsonFunctions.jsonApiCommonSyntax(input, "strict $");
    }

    public static JsonPathContext jsonApiCommonSyntax(String input, String pathSpec) {
        return JsonFunctions.jsonApiCommonSyntax(JsonFunctions.jsonValueExpression(input), pathSpec);
    }

    public static JsonPathContext jsonApiCommonSyntax(JsonValueContext input, String pathSpec) {
        try {
            DocumentContext ctx;
            Matcher matcher = JSON_PATH_BASE.matcher(pathSpec);
            if (!matcher.matches()) {
                throw Static.RESOURCE.illegalJsonPathSpec(pathSpec).ex();
            }
            PathMode mode = PathMode.valueOf(matcher.group(1).toUpperCase(Locale.ROOT));
            String pathWff = matcher.group(2);
            switch (mode) {
                case STRICT: {
                    if (input.hasException()) {
                        return JsonPathContext.withStrictException(input.exc);
                    }
                    ctx = JsonPath.parse(input.obj, Configuration.builder().jsonProvider(JSON_PATH_JSON_PROVIDER).mappingProvider(JSON_PATH_MAPPING_PROVIDER).build());
                    break;
                }
                case LAX: {
                    if (input.hasException()) {
                        return JsonPathContext.withJavaObj(PathMode.LAX, null);
                    }
                    ctx = JsonPath.parse(input.obj, Configuration.builder().options(Option.SUPPRESS_EXCEPTIONS).jsonProvider(JSON_PATH_JSON_PROVIDER).mappingProvider(JSON_PATH_MAPPING_PROVIDER).build());
                    break;
                }
                default: {
                    throw Static.RESOURCE.illegalJsonPathModeInPathSpec(mode.toString(), pathSpec).ex();
                }
            }
            try {
                return JsonPathContext.withJavaObj(mode, ctx.read(pathWff, new Predicate[0]));
            }
            catch (Exception e) {
                return JsonPathContext.withStrictException(e);
            }
        }
        catch (Exception e) {
            return JsonPathContext.withUnknownException(e);
        }
    }

    public static Boolean jsonExists(String input, String pathSpec) {
        return JsonFunctions.jsonExists(JsonFunctions.jsonApiCommonSyntax(input, pathSpec));
    }

    public static Boolean jsonExists(String input, String pathSpec, SqlJsonExistsErrorBehavior errorBehavior) {
        return JsonFunctions.jsonExists(JsonFunctions.jsonApiCommonSyntax(input, pathSpec), errorBehavior);
    }

    public static Boolean jsonExists(JsonValueContext input, String pathSpec) {
        return JsonFunctions.jsonExists(JsonFunctions.jsonApiCommonSyntax(input, pathSpec));
    }

    public static Boolean jsonExists(JsonValueContext input, String pathSpec, SqlJsonExistsErrorBehavior errorBehavior) {
        return JsonFunctions.jsonExists(JsonFunctions.jsonApiCommonSyntax(input, pathSpec), errorBehavior);
    }

    public static Boolean jsonExists(JsonPathContext context) {
        return JsonFunctions.jsonExists(context, SqlJsonExistsErrorBehavior.FALSE);
    }

    public static Boolean jsonExists(JsonPathContext context, SqlJsonExistsErrorBehavior errorBehavior) {
        if (context.hasException()) {
            switch (errorBehavior) {
                case TRUE: {
                    return Boolean.TRUE;
                }
                case FALSE: {
                    return Boolean.FALSE;
                }
                case ERROR: {
                    throw JsonFunctions.toUnchecked(context.exc);
                }
                case UNKNOWN: {
                    return null;
                }
            }
            throw Static.RESOURCE.illegalErrorBehaviorInJsonExistsFunc(errorBehavior.toString()).ex();
        }
        return context.obj != null;
    }

    public static Object jsonValue(String input, String pathSpec, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError) {
        return JsonFunctions.jsonValue(JsonFunctions.jsonApiCommonSyntax(input, pathSpec), emptyBehavior, defaultValueOnEmpty, errorBehavior, defaultValueOnError);
    }

    public static Object jsonValue(JsonValueContext input, String pathSpec, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError) {
        return JsonFunctions.jsonValue(JsonFunctions.jsonApiCommonSyntax(input, pathSpec), emptyBehavior, defaultValueOnEmpty, errorBehavior, defaultValueOnError);
    }

    public static Object jsonValue(JsonPathContext context, SqlJsonValueEmptyOrErrorBehavior emptyBehavior, Object defaultValueOnEmpty, SqlJsonValueEmptyOrErrorBehavior errorBehavior, Object defaultValueOnError) {
        Exception exc;
        if (context.hasException()) {
            exc = context.exc;
        } else {
            Object value = context.obj;
            if (value == null || context.mode == PathMode.LAX && !JsonFunctions.isScalarObject(value)) {
                switch (emptyBehavior) {
                    case ERROR: {
                        throw Static.RESOURCE.emptyResultOfJsonValueFuncNotAllowed().ex();
                    }
                    case NULL: {
                        return null;
                    }
                    case DEFAULT: {
                        return defaultValueOnEmpty;
                    }
                }
                throw Static.RESOURCE.illegalEmptyBehaviorInJsonValueFunc(emptyBehavior.toString()).ex();
            }
            if (context.mode == PathMode.STRICT && !JsonFunctions.isScalarObject(value)) {
                exc = Static.RESOURCE.scalarValueRequiredInStrictModeOfJsonValueFunc(value.toString()).ex();
            } else {
                return value;
            }
        }
        switch (errorBehavior) {
            case ERROR: {
                throw JsonFunctions.toUnchecked(exc);
            }
            case NULL: {
                return null;
            }
            case DEFAULT: {
                return defaultValueOnError;
            }
        }
        throw Static.RESOURCE.illegalErrorBehaviorInJsonValueFunc(errorBehavior.toString()).ex();
    }

    public static String jsonQuery(String input, String pathSpec, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior) {
        return JsonFunctions.jsonQuery(JsonFunctions.jsonApiCommonSyntax(input, pathSpec), wrapperBehavior, emptyBehavior, errorBehavior);
    }

    public static String jsonQuery(JsonValueContext input, String pathSpec, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior) {
        return JsonFunctions.jsonQuery(JsonFunctions.jsonApiCommonSyntax(input, pathSpec), wrapperBehavior, emptyBehavior, errorBehavior);
    }

    public static String jsonQuery(JsonPathContext context, SqlJsonQueryWrapperBehavior wrapperBehavior, SqlJsonQueryEmptyOrErrorBehavior emptyBehavior, SqlJsonQueryEmptyOrErrorBehavior errorBehavior) {
        Exception exc;
        if (context.hasException()) {
            exc = context.exc;
        } else {
            List<Object> value;
            if (context.obj == null) {
                value = null;
            } else {
                switch (wrapperBehavior) {
                    case WITHOUT_ARRAY: {
                        value = context.obj;
                        break;
                    }
                    case WITH_UNCONDITIONAL_ARRAY: {
                        value = Collections.singletonList(context.obj);
                        break;
                    }
                    case WITH_CONDITIONAL_ARRAY: {
                        if (context.obj instanceof Collection) {
                            value = context.obj;
                            break;
                        }
                        value = Collections.singletonList(context.obj);
                        break;
                    }
                    default: {
                        throw Static.RESOURCE.illegalWrapperBehaviorInJsonQueryFunc(wrapperBehavior.toString()).ex();
                    }
                }
            }
            if (value == null || context.mode == PathMode.LAX && JsonFunctions.isScalarObject(value)) {
                switch (emptyBehavior) {
                    case ERROR: {
                        throw Static.RESOURCE.emptyResultOfJsonQueryFuncNotAllowed().ex();
                    }
                    case NULL: {
                        return null;
                    }
                    case EMPTY_ARRAY: {
                        return "[]";
                    }
                    case EMPTY_OBJECT: {
                        return "{}";
                    }
                }
                throw Static.RESOURCE.illegalEmptyBehaviorInJsonQueryFunc(emptyBehavior.toString()).ex();
            }
            if (context.mode == PathMode.STRICT && JsonFunctions.isScalarObject(value)) {
                exc = Static.RESOURCE.arrayOrObjectValueRequiredInStrictModeOfJsonQueryFunc(value.toString()).ex();
            } else {
                try {
                    return JsonFunctions.jsonize(value);
                }
                catch (Exception e) {
                    exc = e;
                }
            }
        }
        switch (errorBehavior) {
            case ERROR: {
                throw JsonFunctions.toUnchecked(exc);
            }
            case NULL: {
                return null;
            }
            case EMPTY_ARRAY: {
                return "[]";
            }
            case EMPTY_OBJECT: {
                return "{}";
            }
        }
        throw Static.RESOURCE.illegalErrorBehaviorInJsonQueryFunc(errorBehavior.toString()).ex();
    }

    public static String jsonObject(SqlJsonConstructorNullClause nullClause, Object ... kvs) {
        assert (kvs.length % 2 == 0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            String k = (String)kvs[i];
            Object v = kvs[i + 1];
            if (k == null) {
                throw Static.RESOURCE.nullKeyOfJsonObjectNotAllowed().ex();
            }
            if (v == null) {
                if (nullClause != SqlJsonConstructorNullClause.NULL_ON_NULL) continue;
                map.put(k, null);
                continue;
            }
            map.put(k, v);
        }
        return JsonFunctions.jsonize(map);
    }

    public static void jsonObjectAggAdd(Map map, String k, Object v, SqlJsonConstructorNullClause nullClause) {
        if (k == null) {
            throw Static.RESOURCE.nullKeyOfJsonObjectNotAllowed().ex();
        }
        if (v == null) {
            if (nullClause == SqlJsonConstructorNullClause.NULL_ON_NULL) {
                map.put(k, null);
            }
        } else {
            map.put(k, v);
        }
    }

    public static String jsonArray(SqlJsonConstructorNullClause nullClause, Object ... elements) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object element : elements) {
            if (element == null) {
                if (nullClause != SqlJsonConstructorNullClause.NULL_ON_NULL) continue;
                list.add(null);
                continue;
            }
            list.add(element);
        }
        return JsonFunctions.jsonize(list);
    }

    public static void jsonArrayAggAdd(List list, Object element, SqlJsonConstructorNullClause nullClause) {
        if (element == null) {
            if (nullClause == SqlJsonConstructorNullClause.NULL_ON_NULL) {
                list.add(null);
            }
        } else {
            list.add(element);
        }
    }

    public static String jsonPretty(String input) {
        return JsonFunctions.jsonPretty(JsonFunctions.jsonValueExpression(input));
    }

    public static String jsonPretty(JsonValueContext input) {
        try {
            return JSON_PATH_JSON_PROVIDER.getObjectMapper().writer(JSON_PRETTY_PRINTER).writeValueAsString(input.obj);
        }
        catch (Exception e) {
            throw Static.RESOURCE.exceptionWhileSerializingToJson(Objects.toString(input.obj)).ex();
        }
    }

    public static String jsonType(String input) {
        return JsonFunctions.jsonType(JsonFunctions.jsonValueExpression(input));
    }

    public static String jsonType(JsonValueContext input) {
        Object val = input.obj;
        try {
            String result;
            if (val instanceof Integer) {
                result = "INTEGER";
            } else if (val instanceof String) {
                result = "STRING";
            } else if (val instanceof Float) {
                result = "FLOAT";
            } else if (val instanceof Double) {
                result = "DOUBLE";
            } else if (val instanceof Long) {
                result = "LONG";
            } else if (val instanceof Boolean) {
                result = "BOOLEAN";
            } else if (val instanceof Date) {
                result = "DATE";
            } else if (val instanceof Map) {
                result = "OBJECT";
            } else if (val instanceof Collection) {
                result = "ARRAY";
            } else if (val == null) {
                result = "NULL";
            } else {
                throw Static.RESOURCE.invalidInputForJsonType(val.toString()).ex();
            }
            return result;
        }
        catch (Exception ex) {
            throw Static.RESOURCE.invalidInputForJsonType(val.toString()).ex();
        }
    }

    public static Integer jsonDepth(String input) {
        return JsonFunctions.jsonDepth(JsonFunctions.jsonValueExpression(input));
    }

    public static Integer jsonDepth(JsonValueContext input) {
        Object o = input.obj;
        try {
            Integer result = o == null ? null : JsonFunctions.calculateDepth(o);
            return result;
        }
        catch (Exception ex) {
            throw Static.RESOURCE.invalidInputForJsonDepth(o.toString()).ex();
        }
    }

    private static Integer calculateDepth(Object o) {
        if (JsonFunctions.isScalarObject(o)) {
            return 1;
        }
        LinkedList<Object> q = new LinkedList<Object>();
        int depth = 0;
        q.add(o);
        while (!q.isEmpty()) {
            int size = q.size();
            for (int i = 0; i < size; ++i) {
                Object obj = q.poll();
                if (obj instanceof Map) {
                    for (Object value : ((LinkedHashMap)obj).values()) {
                        q.add(value);
                    }
                    continue;
                }
                if (!(obj instanceof Collection)) continue;
                for (Object value : (Collection)obj) {
                    q.add(value);
                }
            }
            ++depth;
        }
        return depth;
    }

    public static Integer jsonLength(String input) {
        return JsonFunctions.jsonLength(JsonFunctions.jsonApiCommonSyntax(input));
    }

    public static Integer jsonLength(JsonValueContext input) {
        return JsonFunctions.jsonLength(JsonFunctions.jsonApiCommonSyntax(input));
    }

    public static Integer jsonLength(String input, String pathSpec) {
        return JsonFunctions.jsonLength(JsonFunctions.jsonApiCommonSyntax(input, pathSpec));
    }

    public static Integer jsonLength(JsonValueContext input, String pathSpec) {
        return JsonFunctions.jsonLength(JsonFunctions.jsonApiCommonSyntax(input, pathSpec));
    }

    public static Integer jsonLength(JsonPathContext context) {
        Integer result;
        try {
            if (context.hasException()) {
                throw JsonFunctions.toUnchecked(context.exc);
            }
            Object value = context.obj;
            result = value == null ? null : (value instanceof Collection ? Integer.valueOf(((Collection)value).size()) : (value instanceof Map ? Integer.valueOf(((LinkedHashMap)value).size()) : (JsonFunctions.isScalarObject(value) ? Integer.valueOf(1) : Integer.valueOf(0))));
        }
        catch (Exception ex) {
            throw Static.RESOURCE.invalidInputForJsonLength(context.toString()).ex();
        }
        return result;
    }

    public static String jsonKeys(String input) {
        return JsonFunctions.jsonKeys(JsonFunctions.jsonApiCommonSyntax(input));
    }

    public static String jsonKeys(JsonValueContext input) {
        return JsonFunctions.jsonKeys(JsonFunctions.jsonApiCommonSyntax(input));
    }

    public static String jsonKeys(String input, String pathSpec) {
        return JsonFunctions.jsonKeys(JsonFunctions.jsonApiCommonSyntax(input, pathSpec));
    }

    public static String jsonKeys(JsonValueContext input, String pathSpec) {
        return JsonFunctions.jsonKeys(JsonFunctions.jsonApiCommonSyntax(input, pathSpec));
    }

    public static String jsonKeys(JsonPathContext context) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (context.hasException()) {
                throw JsonFunctions.toUnchecked(context.exc);
            }
            Object value = context.obj;
            if (value == null || value instanceof Collection || JsonFunctions.isScalarObject(value)) {
                list = null;
            } else if (value instanceof Map) {
                for (Object key : ((LinkedHashMap)value).keySet()) {
                    list.add(key.toString());
                }
            }
        }
        catch (Exception ex) {
            throw Static.RESOURCE.invalidInputForJsonKeys(context.toString()).ex();
        }
        return JsonFunctions.jsonize(list);
    }

    public static String jsonRemove(String input, String ... pathSpecs) {
        return JsonFunctions.jsonRemove(JsonFunctions.jsonValueExpression(input), pathSpecs);
    }

    public static String jsonRemove(JsonValueContext input, String ... pathSpecs) {
        try {
            DocumentContext ctx = JsonPath.parse(input.obj, Configuration.builder().options(Option.SUPPRESS_EXCEPTIONS).jsonProvider(JSON_PATH_JSON_PROVIDER).mappingProvider(JSON_PATH_MAPPING_PROVIDER).build());
            for (String pathSpec : pathSpecs) {
                if (pathSpec == null || ctx.read(pathSpec, new Predicate[0]) == null) continue;
                ctx.delete(pathSpec, new Predicate[0]);
            }
            return ctx.jsonString();
        }
        catch (Exception ex) {
            throw Static.RESOURCE.invalidInputForJsonRemove(input.toString(), Arrays.toString(pathSpecs)).ex();
        }
    }

    public static Integer jsonStorageSize(String input) {
        return JsonFunctions.jsonStorageSize(JsonFunctions.jsonValueExpression(input));
    }

    public static Integer jsonStorageSize(JsonValueContext input) {
        try {
            return JSON_PATH_JSON_PROVIDER.getObjectMapper().writeValueAsBytes(input.obj).length;
        }
        catch (Exception e) {
            throw Static.RESOURCE.invalidInputForJsonStorageSize(Objects.toString(input.obj)).ex();
        }
    }

    public static boolean isJsonValue(String input) {
        try {
            JsonFunctions.dejsonize(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJsonObject(String input) {
        try {
            Object o = JsonFunctions.dejsonize(input);
            return o instanceof Map;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJsonArray(String input) {
        try {
            Object o = JsonFunctions.dejsonize(input);
            return o instanceof Collection;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJsonScalar(String input) {
        try {
            Object o = JsonFunctions.dejsonize(input);
            return !(o instanceof Map) && !(o instanceof Collection);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static RuntimeException toUnchecked(Exception e) {
        return Util.toUnchecked(e);
    }

    public static enum PathMode {
        LAX,
        STRICT,
        UNKNOWN,
        NONE;

    }

    public static class JsonValueContext {
        @JsonValue
        public final Object obj;
        public final Exception exc;

        private JsonValueContext(Object obj, Exception exc) {
            assert (obj == null || exc == null);
            this.obj = obj;
            this.exc = exc;
        }

        public static JsonValueContext withJavaObj(Object obj) {
            return new JsonValueContext(obj, null);
        }

        public static JsonValueContext withException(Exception exc) {
            return new JsonValueContext(null, exc);
        }

        public boolean hasException() {
            return this.exc != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonValueContext jsonValueContext = (JsonValueContext)o;
            return Objects.equals(this.obj, jsonValueContext.obj);
        }

        public int hashCode() {
            return Objects.hash(this.obj);
        }

        public String toString() {
            return Objects.toString(this.obj);
        }
    }

    public static class JsonPathContext {
        public final PathMode mode;
        public final Object obj;
        public final Exception exc;

        private JsonPathContext(Object obj, Exception exc) {
            this(PathMode.NONE, obj, exc);
        }

        private JsonPathContext(PathMode mode, Object obj, Exception exc) {
            assert (obj == null || exc == null);
            this.mode = mode;
            this.obj = obj;
            this.exc = exc;
        }

        public boolean hasException() {
            return this.exc != null;
        }

        public static JsonPathContext withUnknownException(Exception exc) {
            return new JsonPathContext(PathMode.UNKNOWN, null, exc);
        }

        public static JsonPathContext withStrictException(Exception exc) {
            return new JsonPathContext(PathMode.STRICT, null, exc);
        }

        public static JsonPathContext withJavaObj(PathMode mode, Object obj) {
            if (mode == PathMode.UNKNOWN) {
                throw Static.RESOURCE.illegalJsonPathMode(mode.toString()).ex();
            }
            if (mode == PathMode.STRICT && obj == null) {
                throw Static.RESOURCE.strictPathModeRequiresNonEmptyValue().ex();
            }
            return new JsonPathContext(mode, obj, null);
        }

        public String toString() {
            return "JsonPathContext{mode=" + (Object)((Object)this.mode) + ", obj=" + this.obj + ", exc=" + this.exc + '}';
        }
    }
}

