/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.schema;

import com.hazelcast.org.apache.calcite.schema.Schema;
import com.hazelcast.org.apache.calcite.schema.Statistic;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.sql.impl.calcite.schema.HazelcastSchema;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTableStatistic;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class HazelcastSchemaUtils {
    private HazelcastSchemaUtils() {
    }

    public static HazelcastSchema createCatalog(Schema schema) {
        return new HazelcastSchema(Collections.singletonMap("hazelcast", schema), Collections.emptyMap());
    }

    public static HazelcastSchema createRootSchema(SqlCatalog catalog) {
        HashMap<String, Schema> schemaMap = new HashMap<String, Schema>();
        for (Map.Entry currentSchemaEntry : catalog.getSchemas().entrySet()) {
            String schemaName = (String)currentSchemaEntry.getKey();
            HashMap<String, Table> schemaTables = new HashMap<String, Table>();
            for (Map.Entry tableEntry : ((Map)currentSchemaEntry.getValue()).entrySet()) {
                String tableName = (String)tableEntry.getKey();
                com.hazelcast.sql.impl.schema.Table table = (com.hazelcast.sql.impl.schema.Table)tableEntry.getValue();
                HazelcastTable convertedTable = new HazelcastTable(table, HazelcastSchemaUtils.createTableStatistic(table));
                schemaTables.put(tableName, convertedTable);
            }
            HazelcastSchema currentSchema = new HazelcastSchema(Collections.emptyMap(), schemaTables);
            schemaMap.put(schemaName, currentSchema);
        }
        HazelcastSchema rootSchema = new HazelcastSchema(schemaMap, Collections.emptyMap());
        return HazelcastSchemaUtils.createCatalog(rootSchema);
    }

    private static Statistic createTableStatistic(com.hazelcast.sql.impl.schema.Table table) {
        return new HazelcastTableStatistic(table.getStatistics().getRowCount());
    }
}

