/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.runtime.CalciteException;
import com.hazelcast.org.apache.calcite.runtime.Resources;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBindingSignatureErrorAware;
import com.hazelcast.sql.impl.calcite.validate.HazelcastResources;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlValidator;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collection;
import java.util.StringJoiner;

public class HazelcastCallBinding
extends SqlCallBinding {
    public HazelcastCallBinding(SqlCallBinding binding) {
        super(binding.getValidator(), binding.getScope(), binding.getCall());
    }

    @Override
    public HazelcastSqlValidator getValidator() {
        return (HazelcastSqlValidator)super.getValidator();
    }

    @Override
    public CalciteException newValidationSignatureError() {
        Resources.ExInst<SqlValidatorException> error;
        SqlOperator operator = this.getOperator();
        HazelcastSqlValidator validator = this.getValidator();
        SqlCall call = this.getCall();
        String operandTypes = HazelcastCallBinding.getOperandTypes(validator, call, this.getScope());
        String operatorName = '\'' + operator.getName() + '\'';
        switch (operator.getSyntax()) {
            case FUNCTION: 
            case FUNCTION_STAR: 
            case FUNCTION_ID: {
                error = HazelcastResources.RESOURCES.invalidFunctionOperands(operatorName, operandTypes);
                break;
            }
            default: {
                error = HazelcastResources.RESOURCES.invalidOperatorOperands(operatorName, operandTypes);
            }
        }
        return validator.newValidationError(call, error);
    }

    private static String getOperandTypes(SqlValidator validator, SqlCall call, SqlValidatorScope scope) {
        StringJoiner res = new StringJoiner(", ", "[", "]");
        for (SqlNode operand : HazelcastCallBinding.getOperands(call)) {
            String typeName;
            RelDataType calciteType = validator.deriveType(scope, operand);
            if (calciteType.getSqlTypeName() == SqlTypeName.NULL) {
                typeName = validator.getUnknownType().toString();
            } else {
                QueryDataType hazelcastType = HazelcastTypeUtils.toHazelcastType(calciteType.getSqlTypeName());
                typeName = hazelcastType.getTypeFamily().getPublicType().name();
            }
            res.add(typeName);
        }
        return res.toString();
    }

    private static Collection<SqlNode> getOperands(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator instanceof HazelcastCallBindingSignatureErrorAware) {
            return ((HazelcastCallBindingSignatureErrorAware)((Object)operator)).getOperandsForSignatureError(call);
        }
        return call.getOperandList();
    }
}

